/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.cms.CMSSignedData;

public class CMSSignedDocument
extends CommonDocument {
    protected CMSSignedData signedData;

    public CMSSignedDocument(CMSSignedData data) {
        Objects.requireNonNull(data, "The CMSSignedData cannot be null");
        this.signedData = data;
        this.mimeType = MimeType.PKCS7;
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public CMSSignedData getCMSSignedData() {
        return this.signedData;
    }

    public byte[] getBytes() {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.writeTo(output);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException((Throwable)e);
            }
        }
        output.close();
        return byArray;
    }

    public String getBase64Encoded() {
        return Utils.toBase64((byte[])this.getBytes());
    }

    public void writeTo(OutputStream stream) throws IOException {
        byte[] encoded = this.signedData.getEncoded();
        ASN1Primitive asn1Primitive = DSSASN1Utils.toASN1Primitive((byte[])encoded);
        ASN1OutputStream asn1OutputStream = ASN1OutputStream.create((OutputStream)stream, (String)"DER");
        asn1OutputStream.writeObject(asn1Primitive);
    }

    public String getAbsolutePath() {
        return super.getName();
    }
}

