/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.uris;

import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.Query;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.paths.Normalized;

public final class Resolved
implements Uri {
    private final Uri mBase;
    private final Uri mReference;

    public Resolved(Uri base, Uri reference) {
        this.mBase = base;
        this.mReference = reference;
    }

    @Override
    public Optional<? extends Scheme> scheme() {
        return this.mReference.isAbsolute() ? this.mReference.scheme() : this.mBase.scheme();
    }

    @Override
    public Optional<? extends Authority> authority() {
        return this.mReference.isAbsolute() || this.mReference.authority().isPresent() ? this.mReference.authority() : this.mBase.authority();
    }

    @Override
    public Path path() {
        return this.mReference.isAbsolute() || this.mReference.authority().isPresent() ? new Normalized(this.mReference.path()) : new org.dmfs.rfc3986.paths.Resolved(this.mBase.path(), this.mReference.path());
    }

    @Override
    public Optional<? extends Query> query() {
        return this.mReference.isAbsolute() || this.mReference.authority().isPresent() || !this.mReference.path().isEmpty() || this.mReference.query().isPresent() ? this.mReference.query() : this.mBase.query();
    }

    @Override
    public Optional<? extends Fragment> fragment() {
        return this.mReference.fragment();
    }

    @Override
    public boolean isHierarchical() {
        return this.mBase.isHierarchical() || this.mReference.isHierarchical();
    }

    @Override
    public boolean isAbsolute() {
        return this.mBase.isAbsolute() || this.mReference.isAbsolute();
    }
}

