/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.Properties;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportXHTMLProperties {
    protected static Logger log = LoggerFactory.getLogger(ImportXHTMLProperties.class);
    private static Properties properties;

    private static void init() {
        properties = new Properties();
        try {
            properties.load(ResourceUtils.getResource((String)"docx4j-ImportXHTML.properties"));
        }
        catch (Exception e) {
            log.warn("Couldn't find/read docx4j-ImportXHTML.properties; " + e.getMessage());
        }
    }

    public static String getProperty(String key) {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        return properties.getProperty(key, defaultValue);
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        String result = properties.getProperty(key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(result);
    }

    public static Properties getProperties() {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        return properties;
    }

    public static void setProperty(String key, Boolean value) {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        properties.setProperty(key, value.toString());
    }

    public static void setProperty(String key, String value) {
        if (properties == null) {
            ImportXHTMLProperties.init();
        }
        properties.setProperty(key, value);
    }
}

