/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.dml.BaseStyles;
import org.docx4j.dml.FontCollection;
import org.docx4j.dml.TextFont;
import org.docx4j.dml.Theme;
import org.docx4j.fonts.LanguageTagToScriptMapping;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.STTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemePart
extends JaxbXmlPartXPathAware<Theme> {
    private static Logger log = LoggerFactory.getLogger(ThemePart.class);
    private BaseStyles.FontScheme fontScheme = null;
    private Map<String, String> scriptToTypefaceMajor = null;
    private Map<String, String> scriptToTypefaceMinor = null;
    private FontCollection majorFontCollection = null;
    private boolean majorFontCollectionInitialised = false;
    private FontCollection minorFontCollection = null;
    private boolean minorFontCollectionInitialised = false;
    private TextFont majorLatin = null;
    private TextFont majorEastAsian = null;
    private TextFont majorComplexScript = null;
    private TextFont minorLatin = null;
    private TextFont minorEastAsian = null;
    private TextFont minorComplexScript = null;
    private boolean reportedEmptyMINOR_EAST_ASIA = false;

    public ThemePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public ThemePart() throws InvalidFormatException {
        super(new PartName("/word/theme/theme1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.theme+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme");
    }

    public BaseStyles.FontScheme getFontScheme() {
        Theme theme;
        if (this.fontScheme == null && (theme = (Theme)this.getJaxbElement()).getThemeElements() != null && theme.getThemeElements().getFontScheme() != null) {
            this.fontScheme = theme.getThemeElements().getFontScheme();
        }
        return this.fontScheme;
    }

    private Map<String, String> getScriptToTypefaceMajor() throws Docx4JException {
        if (this.scriptToTypefaceMajor == null) {
            this.scriptToTypefaceMajor = new HashMap<String, String>();
            if (this.getMajorFontCollection() != null) {
                for (FontCollection.Font f : this.majorFontCollection.getFont()) {
                    this.scriptToTypefaceMajor.put(f.getScript(), f.getTypeface());
                }
            }
        }
        return this.scriptToTypefaceMajor;
    }

    private Map<String, String> getScriptToTypefaceMinor() throws Docx4JException {
        if (this.scriptToTypefaceMinor == null) {
            this.scriptToTypefaceMinor = new HashMap<String, String>();
            if (this.getMinorFontCollection() != null) {
                for (FontCollection.Font f : this.minorFontCollection.getFont()) {
                    this.scriptToTypefaceMinor.put(f.getScript(), f.getTypeface());
                }
            }
        }
        return this.scriptToTypefaceMinor;
    }

    private FontCollection getMajorFontCollection() throws Docx4JException {
        if (this.majorFontCollectionInitialised) {
            return this.majorFontCollection;
        }
        if (((Theme)this.getContents()).getThemeElements() != null && ((Theme)this.getContents()).getThemeElements().getFontScheme() != null) {
            this.majorFontCollection = ((Theme)this.getContents()).getThemeElements().getFontScheme().getMajorFont();
        }
        this.majorFontCollectionInitialised = true;
        return this.majorFontCollection;
    }

    private FontCollection getMinorFontCollection() throws Docx4JException {
        if (this.minorFontCollectionInitialised) {
            return this.minorFontCollection;
        }
        if (((Theme)this.getContents()).getThemeElements() != null && ((Theme)this.getContents()).getThemeElements().getFontScheme() != null) {
            this.minorFontCollection = ((Theme)this.getContents()).getThemeElements().getFontScheme().getMinorFont();
        }
        this.minorFontCollectionInitialised = true;
        return this.minorFontCollection;
    }

    public TextFont getMajorLatin() throws Docx4JException {
        if (this.majorLatin == null && this.getMajorFontCollection() != null) {
            this.majorLatin = this.getMajorFontCollection().getLatin();
        }
        return this.majorLatin;
    }

    private TextFont getMajorHighAnsi() throws Docx4JException {
        return this.getMajorLatin();
    }

    private TextFont getMajorEastAsian() throws Docx4JException {
        if (this.majorEastAsian == null && this.getMajorFontCollection() != null) {
            this.majorEastAsian = this.getMajorFontCollection().getEa();
        }
        return this.majorEastAsian;
    }

    private TextFont getMajorComplexScript() throws Docx4JException {
        if (this.majorComplexScript == null && this.getMajorFontCollection() != null) {
            this.majorComplexScript = this.getMajorFontCollection().getCs();
        }
        return this.majorComplexScript;
    }

    private TextFont getMinorLatin() throws Docx4JException {
        if (this.minorLatin == null && this.getMinorFontCollection() != null) {
            this.minorLatin = this.getMinorFontCollection().getLatin();
        }
        return this.minorLatin;
    }

    private TextFont getMinorHighAnsi() throws Docx4JException {
        return this.getMinorLatin();
    }

    private TextFont getMinorEastAsian() throws Docx4JException {
        if (this.minorEastAsian == null && this.getMinorFontCollection() != null) {
            this.minorEastAsian = this.getMinorFontCollection().getEa();
        }
        return this.minorEastAsian;
    }

    private TextFont getMinorComplexScript() throws Docx4JException {
        if (this.minorComplexScript == null && this.getMinorFontCollection() != null) {
            this.minorComplexScript = this.getMinorFontCollection().getCs();
        }
        return this.minorComplexScript;
    }

    private TextFont getTextFontFromTheme(STTheme type) throws Docx4JException {
        if (type.equals((Object)STTheme.MAJOR_EAST_ASIA)) {
            return this.getMajorEastAsian();
        }
        if (type.equals((Object)STTheme.MINOR_EAST_ASIA)) {
            return this.getMinorEastAsian();
        }
        if (type.equals((Object)STTheme.MAJOR_ASCII)) {
            return this.getMajorLatin();
        }
        if (type.equals((Object)STTheme.MINOR_ASCII)) {
            return this.getMinorLatin();
        }
        if (type.equals((Object)STTheme.MAJOR_BIDI)) {
            return this.getMajorComplexScript();
        }
        if (type.equals((Object)STTheme.MINOR_BIDI)) {
            return this.getMinorComplexScript();
        }
        if (type.equals((Object)STTheme.MAJOR_H_ANSI)) {
            return this.getMajorHighAnsi();
        }
        if (type.equals((Object)STTheme.MINOR_H_ANSI)) {
            return this.getMinorHighAnsi();
        }
        return this.getMinorLatin();
    }

    public String getFontFromTheme(STTheme type) throws Docx4JException {
        TextFont textFont = this.getTextFontFromTheme(type);
        if (textFont == null) {
            log.warn("No font specified for " + type.toString());
            return null;
        }
        String typeface = textFont.getTypeface();
        if (typeface == null) {
            log.warn("Missing typeface in font for " + type.toString());
            return null;
        }
        if (typeface.trim().length() == 0) {
            if (type.equals((Object)STTheme.MINOR_EAST_ASIA)) {
                if (!this.reportedEmptyMINOR_EAST_ASIA) {
                    log.info("Empty typeface in font for " + type.toString());
                    this.reportedEmptyMINOR_EAST_ASIA = true;
                }
            } else {
                log.info("Empty typeface in font for " + type.toString());
            }
            return null;
        }
        log.debug("'" + typeface + "'");
        return typeface;
    }

    public String getFont(STTheme type, CTLanguage themeFontLang) throws Docx4JException {
        if (themeFontLang == null) {
            log.debug("themeFontLang==null");
            return this.getFontFromTheme(type);
        }
        log.debug(themeFontLang.toString());
        log.debug(type.toString());
        String lang = this.getLang(themeFontLang, type);
        if (lang == null) {
            log.debug("lang==null");
            return this.getFontFromTheme(type);
        }
        log.debug("--> " + lang);
        String script = LanguageTagToScriptMapping.getScriptForLanguageTag(lang);
        log.debug("--> script: " + script);
        if (script == null) {
            return this.getFontFromTheme(type);
        }
        String typeface = null;
        typeface = this.isMajor(type) ? this.getScriptToTypefaceMajor().get(script) : this.getScriptToTypefaceMinor().get(script);
        if (typeface == null) {
            return this.getFontFromTheme(type);
        }
        return typeface;
    }

    private boolean isMajor(STTheme type) {
        return type == STTheme.MAJOR_ASCII || type == STTheme.MAJOR_BIDI || type == STTheme.MAJOR_EAST_ASIA || type == STTheme.MAJOR_H_ANSI;
    }

    private String getLang(CTLanguage themeFontLang, STTheme range) {
        if (range == STTheme.MAJOR_ASCII || range == STTheme.MINOR_ASCII || range == STTheme.MAJOR_H_ANSI || range == STTheme.MINOR_H_ANSI) {
            if (themeFontLang.getVal() == null) {
                return null;
            }
            return themeFontLang.getVal();
        }
        if (range == STTheme.MAJOR_BIDI || range == STTheme.MINOR_BIDI) {
            if (themeFontLang.getBidi() == null) {
                return null;
            }
            return themeFontLang.getBidi();
        }
        if (themeFontLang.getEastAsia() == null) {
            return null;
        }
        return themeFontLang.getEastAsia();
    }
}

