/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import org.drools.model.Variable;
import org.drools.model.constraints.AbstractSingleConstraint;
import org.drools.model.constraints.FixedTemporalConstraint;
import org.drools.model.constraints.VariableTemporalConstraint;
import org.drools.model.functions.PredicateN;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.model.view.FixedTemporalExprViewItem;
import org.drools.model.view.TemporalExprViewItem;
import org.drools.model.view.VariableTemporalExprViewItem;

public abstract class TemporalConstraint<A>
extends AbstractSingleConstraint {
    protected final Variable<A> var1;
    protected final TemporalPredicate temporalPredicate;

    public TemporalConstraint(String exprId, Variable<A> var1, TemporalPredicate temporalPredicate) {
        super(exprId);
        this.var1 = var1;
        this.temporalPredicate = temporalPredicate;
    }

    @Override
    public PredicateN getPredicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    public TemporalPredicate getTemporalPredicate() {
        return this.temporalPredicate;
    }

    public static <A> TemporalConstraint<A> createTemporalConstraint(TemporalExprViewItem<A> expr) {
        if (expr instanceof FixedTemporalExprViewItem) {
            return new FixedTemporalConstraint((FixedTemporalExprViewItem)expr);
        }
        if (expr instanceof VariableTemporalExprViewItem) {
            return new VariableTemporalConstraint((VariableTemporalExprViewItem)expr);
        }
        throw new UnsupportedOperationException("Unknown expression " + expr);
    }
}

