/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.Arrays;
import org.drools.model.Argument;
import org.drools.model.Condition;
import org.drools.model.QueryDef;
import org.drools.model.Variable;
import org.drools.model.impl.ModelComponent;
import org.drools.model.view.QueryCallViewItem;

public class QueryCallPattern
implements Condition,
ModelComponent {
    private final QueryDef query;
    private final boolean open;
    private final Argument<?>[] arguments;

    public QueryCallPattern(QueryCallViewItem queryCallView) {
        this(queryCallView.getQuery(), queryCallView.isOpen(), queryCallView.getArguments());
    }

    public QueryCallPattern(QueryDef query, boolean open, Argument<?> ... arguments) {
        this.query = query;
        this.open = open;
        this.arguments = arguments;
    }

    public QueryDef getQuery() {
        return this.query;
    }

    public Argument<?>[] getArguments() {
        return this.arguments;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.QUERY;
    }

    @Override
    public Variable<?>[] getBoundVariables() {
        throw new UnsupportedOperationException("org.drools.model.patterns.QueryCallPattern.getBoundVariables -> TODO");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryCallPattern)) {
            return false;
        }
        QueryCallPattern that = (QueryCallPattern)o;
        if (this.open != that.open) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        return Arrays.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.open ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    @Override
    public boolean isEqualTo(ModelComponent other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueryCallPattern)) {
            return false;
        }
        QueryCallPattern that = (QueryCallPattern)other;
        return this.open == that.open && ModelComponent.areEqualInModel(this.query, that.query) && ModelComponent.areEqualInModel(this.arguments, that.arguments);
    }
}

