/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DescrBuilderTree;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsTree;
import org.drools.lang.DroolsTreeAdaptor;
import org.drools.lang.Expander;
import org.drools.lang.ExpanderException;
import org.drools.lang.Location;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DefaultExpanderResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrlParser {
    private static final String GENERIC_ERROR_MESSAGE = "Unexpected exception raised while parsing. This is a bug. Please contact the Development team :\n";
    private final List<DroolsError> results = new ArrayList<DroolsError>();
    private List<DroolsSentence> editorSentences = null;
    private Location location = new Location(0);
    private DescrBuilderTree walker = null;
    private DRLLexer lexer = null;

    public PackageDescr parse(String text) throws DroolsParserException {
        return this.parse(false, text);
    }

    public PackageDescr parse(boolean isEditor, String text) throws DroolsParserException {
        DRLParser parser = this.getParser(text);
        return this.compile(isEditor, parser);
    }

    public PackageDescr parse(boolean isEditor, Reader reader) throws DroolsParserException {
        DRLParser parser = this.getParser(reader);
        return this.compile(isEditor, parser);
    }

    public PackageDescr parse(Reader reader) throws DroolsParserException {
        return this.parse(false, reader);
    }

    public PackageDescr parse(Reader drl, Reader dsl) throws DroolsParserException, IOException {
        return this.parse(false, drl, dsl);
    }

    public PackageDescr parse(boolean isEditor, Reader drl, Reader dsl) throws DroolsParserException, IOException {
        StringBuilder text = this.getDRLText(drl);
        return this.parse(text.toString(), dsl);
    }

    public PackageDescr parse(boolean isEditor, String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver = this.getDefaultResolver(dsl);
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            this.results.addAll(expander.getErrors());
        }
        return this.parse(isEditor, expanded);
    }

    public PackageDescr parse(String source, Reader dsl) throws DroolsParserException {
        return this.parse(false, source, dsl);
    }

    public PackageDescr parse(boolean isEditor, InputStream is) throws DroolsParserException {
        DRLParser parser = this.getParser(is);
        return this.compile(isEditor, parser);
    }

    public PackageDescr parse(InputStream is) throws DroolsParserException {
        return this.parse(false, is);
    }

    public String getExpandedDRL(String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver = this.getDefaultResolver(dsl);
        return this.getExpandedDRL(source, resolver);
    }

    public String getExpandedDRL(String source, DefaultExpanderResolver resolver) throws DroolsParserException {
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            String err = "";
            for (ExpanderException ex : expander.getErrors()) {
                err = err + "\n Line:[" + ex.getLine() + "] " + ex.getMessage();
            }
            throw new DroolsParserException(err);
        }
        return expanded;
    }

    private StringBuilder getDRLText(Reader reader) throws IOException {
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    public boolean hasErrors() {
        return !this.results.isEmpty();
    }

    public List<DroolsError> getErrors() {
        return this.results;
    }

    private PackageDescr compile(boolean isEditor, DRLParser parser) throws DroolsParserException {
        try {
            if (isEditor) {
                parser.enableEditorInterface();
            }
            DroolsTree resultTree = (DroolsTree)((Object)parser.compilation_unit().getTree());
            this.editorSentences = parser.getEditorInterface();
            this.makeErrorList(parser);
            if (isEditor || !this.hasErrors()) {
                return this.walk(parser.getTokenStream(), (Tree)resultTree);
            }
            return null;
        }
        catch (Exception e) {
            ParserError err = new ParserError(GENERIC_ERROR_MESSAGE + e.toString() + "\n" + Arrays.toString(e.getStackTrace()), -1, 0);
            this.results.add(err);
            if (isEditor) {
                if (this.walker == null) {
                    return null;
                }
                return this.walker.getPackageDescr();
            }
            throw new DroolsParserException(GENERIC_ERROR_MESSAGE + e.getMessage(), e);
        }
    }

    private PackageDescr walk(TokenStream tokenStream, Tree resultTree) throws RecognitionException {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)resultTree);
        nodes.setTokenStream(tokenStream);
        this.walker = new DescrBuilderTree((TreeNodeStream)nodes);
        this.walker.compilation_unit();
        return this.walker.getPackageDescr();
    }

    private void makeErrorList(DRLParser parser) {
        ParserError err;
        for (DroolsParserException recogErr : this.lexer.getErrors()) {
            err = new ParserError(recogErr.getMessage(), recogErr.getLineNumber(), recogErr.getColumn());
            this.results.add(err);
        }
        for (DroolsParserException recogErr : parser.getErrors()) {
            err = new ParserError(recogErr.getMessage(), recogErr.getLineNumber(), recogErr.getColumn());
            this.results.add(err);
        }
    }

    private DRLParser getParser(String text) {
        this.lexer = new DRLLexer((CharStream)new ANTLRStringStream(text));
        DRLParser parser = new DRLParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        parser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
        return parser;
    }

    private DRLParser getParser(Reader reader) {
        try {
            this.lexer = new DRLLexer((CharStream)new ANTLRReaderStream(reader));
            DRLParser parser = new DRLParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
            parser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
            return parser;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    private DRLParser getParser(InputStream is) {
        try {
            this.lexer = new DRLLexer((CharStream)new ANTLRInputStream(is));
            DRLParser parser = new DRLParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
            parser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
            return parser;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public DefaultExpanderResolver getDefaultResolver(Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver;
        try {
            resolver = new DefaultExpanderResolver(dsl);
        }
        catch (IOException e) {
            throw new DroolsParserException("Error parsing the DSL.", e);
        }
        return resolver;
    }

    public List<DroolsSentence> getEditorSentences() {
        return this.editorSentences;
    }
}

