/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.CompositeMaxDurationTrigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class CompositeMaxDurationTimer
extends BaseTimer
implements Timer {
    private static final long serialVersionUID = -2531364489959820962L;
    private List<DurationTimer> durations;
    private Timer timer;

    public void addDurationTimer(DurationTimer durationTimer) {
        if (this.durations == null) {
            this.durations = new LinkedList<DurationTimer>();
        }
        this.durations.add(durationTimer);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, LeftTuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        if (this.durations == null) {
            throw new IllegalStateException("CompositeMaxDurationTimer cannot have no durations");
        }
        Date maxDurationDate = new Date(this.getMaxDuration() + timestamp);
        return new CompositeMaxDurationTrigger(maxDurationDate, this.timer != null ? this.timer.createTrigger(timestamp, calendarNames, calendars) : null, calendarNames, calendars);
    }

    private long getMaxDuration() {
        long result = 0L;
        for (DurationTimer durationTimer : this.durations) {
            result = Math.max(result, durationTimer.getDuration());
        }
        return result;
    }

    @Override
    public ConditionalElement clone() {
        CompositeMaxDurationTimer clone = new CompositeMaxDurationTimer();
        if (this.durations != null && !this.durations.isEmpty()) {
            for (DurationTimer timer : this.durations) {
                clone.addDurationTimer(timer);
            }
        }
        if (this.timer != null) {
            clone.timer = this.timer;
        }
        return clone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.durations);
        out.writeObject(this.timer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.durations = (List)in.readObject();
        this.timer = (Timer)in.readObject();
    }
}

