/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.LeftTupleList;

public class TimerNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private Timer timer;
    private String[] calendarNames;
    private boolean tupleMemoryEnabled;
    private Declaration[][] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public TimerNode() {
    }

    public TimerNode(int id, LeftTupleSource tupleSource, Timer timer, String[] calendarNames, Declaration[][] declarations, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(tupleSource);
        this.timer = timer;
        this.calendarNames = calendarNames;
        this.declarations = declarations;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.timer = (Timer)in.readObject();
        this.calendarNames = (String[])in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.declarations = (Declaration[][])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.timer);
        out.writeObject(this.calendarNames);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.declarations);
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
        if (context == null || context.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        throw new UnsupportedOperationException("Phreak Only Node");
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public String[] getCalendarNames() {
        return this.calendarNames;
    }

    public Declaration[][] getDeclarations() {
        return this.declarations;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public String toString() {
        return "[TimeNodeNode: cond=" + this.timer + " calendars=" + (this.calendarNames == null ? "null" : Arrays.asList(this.calendarNames)) + "]";
    }

    @Override
    public int hashCode() {
        int hash = this.leftInput.hashCode() ^ this.timer.hashCode();
        if (this.calendarNames != null) {
            for (int i = 0; i < this.calendarNames.length; ++i) {
                hash ^= this.calendarNames[i].hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != TimerNode.class) {
            return false;
        }
        TimerNode other = (TimerNode)object;
        if (this.calendarNames != null) {
            if (other.getCalendarNames() == null || other.getCalendarNames().length != this.calendarNames.length) {
                return false;
            }
            for (int i = 0; i < this.calendarNames.length; ++i) {
                if (other.getCalendarNames()[i].equals(this.calendarNames[i])) continue;
                return false;
            }
        }
        return Arrays.deepEquals((Object[])this.declarations, (Object[])other.declarations) && this.timer.equals(other.timer) && this.leftInput.equals(other.leftInput);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new TimerNodeMemory();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
        }
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 133;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    public static class TimerNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private static final long serialVersionUID = 510L;
        private LeftTupleList insertOrUpdateLeftTuples = new LeftTupleList();
        private LeftTupleList deleteLeftTuples = new LeftTupleList();
        private SegmentMemory memory;
        private long nodePosMaskBit;

        public LeftTupleList getInsertOrUpdateLeftTuples() {
            return this.insertOrUpdateLeftTuples;
        }

        public LeftTupleList getDeleteLeftTuples() {
            return this.deleteLeftTuples;
        }

        @Override
        public short getNodeType() {
            return 133;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.memory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.memory = smem;
        }

        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        public void setNodePosMaskBit(long segmentPos) {
            this.nodePosMaskBit = segmentPos;
        }

        public void setNodeDirtyWithoutNotify() {
            this.memory.updateDirtyNodeMask(this.nodePosMaskBit);
        }

        public void setNodeCleanWithoutNotify() {
            this.memory.updateCleanNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.insertOrUpdateLeftTuples.clear();
            this.deleteLeftTuples.clear();
        }
    }
}

