/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class Config {
    public static String getConfig(String propertyName) {
        return ConfigResolverHolder.CONFIG_RESOLVER.getConfig(propertyName);
    }

    public static String getConfig(String propertyName, String defaultValue) {
        return ConfigResolverHolder.CONFIG_RESOLVER.getConfig(propertyName, defaultValue);
    }

    public static Optional<String> getOptionalConfig(String propertyName) {
        return ConfigResolverHolder.CONFIG_RESOLVER.getOptionalConfig(propertyName);
    }

    private static class SystemPropertyConfigResolver
    implements ConfigResolver {
        private SystemPropertyConfigResolver() {
        }

        @Override
        public String getConfig(String propertyName) {
            return System.getProperty(propertyName);
        }

        @Override
        public String getConfig(String propertyName, String defaultValue) {
            return System.getProperty(propertyName, defaultValue);
        }

        @Override
        public Optional<String> getOptionalConfig(String propertyName) {
            return Optional.ofNullable(this.getConfig(propertyName));
        }
    }

    private static class MicroprofileConfigResolver
    implements ConfigResolver {
        private final org.eclipse.microprofile.config.Config config;

        private MicroprofileConfigResolver(org.eclipse.microprofile.config.Config config) {
            this.config = config;
        }

        @Override
        public String getConfig(String propertyName) {
            return this.getConfig(propertyName, null);
        }

        @Override
        public String getConfig(String propertyName, String defaultValue) {
            return this.getOptionalConfig(propertyName).orElse(defaultValue);
        }

        @Override
        public Optional<String> getOptionalConfig(String propertyName) {
            return this.config.getOptionalValue(propertyName, String.class);
        }
    }

    private static class ConfigResolverHolder {
        private static final ConfigResolver CONFIG_RESOLVER = ConfigResolverHolder.createConfigResolver();

        private ConfigResolverHolder() {
        }

        private static ConfigResolver createConfigResolver() {
            try {
                return new MicroprofileConfigResolver(ConfigProvider.getConfig());
            }
            catch (Exception e) {
                return new SystemPropertyConfigResolver();
            }
        }
    }

    static interface ConfigResolver {
        public String getConfig(String var1);

        public String getConfig(String var1, String var2);

        public Optional<String> getOptionalConfig(String var1);
    }
}

