/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.events;

import java.util.Date;
import org.jbpm.simulation.impl.events.GenericSimulationEvent;

public class ProcessInstanceEndSimulationEvent
extends GenericSimulationEvent {
    private String pathId;
    private long processDuration;
    private String processName;
    private String processVersion;

    public ProcessInstanceEndSimulationEvent(String processId, long processInstanceId, long startTime, long endTime, String pathId, String processName, String processVersion) {
        super(processId, processInstanceId, startTime, endTime, "process-instance");
        this.pathId = pathId;
        this.processDuration = endTime - startTime;
        this.processName = processName;
        this.processVersion = processVersion;
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    @Override
    public String toString() {
        return "GenericSimulationEvent[process=" + this.processId + ", instance=" + this.processInstanceId + ", uuid=" + this.uuid + ", pathId=" + this.pathId + " started at " + new Date(this.startTime) + " finished at " + new Date(this.endTime) + "]";
    }

    public long getProcessDuration() {
        return this.processDuration;
    }

    public void setProcessDuration(long processDuration) {
        this.processDuration = processDuration;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }
}

