/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import org.duckdb.DuckDBVector;

public class DuckDBStruct
implements Struct {
    private final Object[] attributes;
    private final String[] keys;
    private final DuckDBVector[] values;
    private final int offset;
    private final String typeName;

    DuckDBStruct(String[] stringArray, DuckDBVector[] duckDBVectorArray, int n, String string) throws SQLException {
        this.keys = stringArray;
        this.values = duckDBVectorArray;
        this.offset = n;
        this.typeName = string;
        this.attributes = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            this.attributes[i] = this.values[i].getObject(this.offset);
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        return this.getAttributes();
    }

    public Map<String, Object> getMap() throws SQLException {
        Object[] objectArray = this.getAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(this.keys[i], objectArray[i]);
        }
        return hashMap;
    }

    public String toString() {
        Object object = null;
        try {
            object = this.getMap();
        }
        catch (SQLException sQLException) {
            object = sQLException;
        }
        return object.toString();
    }
}

