/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Collection;
import java.util.Comparator;
import org.fest.assertions.core.Assert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.WritableAssertionInfo;
import org.fest.assertions.description.Description;
import org.fest.assertions.internal.Conditions;
import org.fest.assertions.internal.Objects;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssert<S, A>
implements Assert<S, A> {
    @VisibleForTesting
    Objects objects = Objects.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    final WritableAssertionInfo info;
    @VisibleForTesting
    protected final A actual;
    protected final S myself;

    protected AbstractAssert(A actual, Class<S> selfType) {
        this.myself = selfType.cast(this);
        this.actual = actual;
        this.info = new WritableAssertionInfo();
    }

    @Override
    public final S as(String description) {
        return this.describedAs(description);
    }

    @Override
    public final S as(Description description) {
        return this.describedAs(description);
    }

    @Override
    public final S describedAs(String description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public final S describedAs(Description description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public S isEqualTo(A expected) {
        this.objects.assertEqual(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public S isNotEqualTo(A other) {
        this.objects.assertNotEqual(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public final void isNull() {
        this.objects.assertNull(this.info, this.actual);
    }

    @Override
    public final S isNotNull() {
        this.objects.assertNotNull(this.info, this.actual);
        return this.myself;
    }

    @Override
    public final S isSameAs(A expected) {
        this.objects.assertSame(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public final S isNotSameAs(A other) {
        this.objects.assertNotSame(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public final S isIn(A ... values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public final S isNotIn(A ... values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public final S isIn(Collection<?> values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public final S isNotIn(Collection<?> values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public final S is(Condition<A> condition) {
        this.conditions.assertIs(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public final S isNot(Condition<A> condition) {
        this.conditions.assertIsNot(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public final S has(Condition<A> condition) {
        this.conditions.assertHas(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public final S doesNotHave(Condition<A> condition) {
        this.conditions.assertDoesNotHave(this.info, this.actual, condition);
        return this.myself;
    }

    public final String descriptionText() {
        return this.info.descriptionText();
    }

    @Override
    public S usingComparator(Comparator<?> customComparator) {
        this.objects = new Objects((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return this.myself;
    }

    @Override
    public S usingDefaultComparator() {
        this.objects = Objects.instance();
        return this.myself;
    }

    @Override
    public final boolean equals(Object obj) {
        throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
    }

    public final int hashCode() {
        return 1;
    }
}

