/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.LongArrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayAssert
extends AbstractAssert<LongArrayAssert, long[]>
implements EnumerableAssert<LongArrayAssert>,
ArraySortedAssert<LongArrayAssert, Long> {
    @VisibleForTesting
    LongArrays arrays = LongArrays.instance();

    protected LongArrayAssert(long[] actual) {
        super(actual, LongArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (long[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (long[])this.actual);
    }

    @Override
    public LongArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (long[])this.actual);
        return this;
    }

    @Override
    public LongArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (long[])this.actual, expected);
        return this;
    }

    public LongArrayAssert contains(long ... values) {
        this.arrays.assertContains(this.info, (long[])this.actual, values);
        return this;
    }

    public LongArrayAssert containsOnly(long ... values) {
        this.arrays.assertContainsOnly(this.info, (long[])this.actual, values);
        return this;
    }

    public LongArrayAssert containsSequence(long ... sequence) {
        this.arrays.assertContainsSequence(this.info, (long[])this.actual, sequence);
        return this;
    }

    public LongArrayAssert contains(long value, Index index) {
        this.arrays.assertContains(this.info, (long[])this.actual, value, index);
        return this;
    }

    public LongArrayAssert doesNotContain(long ... values) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, values);
        return this;
    }

    public LongArrayAssert doesNotContain(long value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, value, index);
        return this;
    }

    public LongArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (long[])this.actual);
        return this;
    }

    public LongArrayAssert startsWith(long ... sequence) {
        this.arrays.assertStartsWith(this.info, (long[])this.actual, sequence);
        return this;
    }

    public LongArrayAssert endsWith(long ... sequence) {
        this.arrays.assertEndsWith(this.info, (long[])this.actual, sequence);
        return this;
    }

    @Override
    public LongArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (long[])this.actual);
        return this;
    }

    @Override
    public LongArrayAssert isSortedAccordingTo(Comparator<? extends Long> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (long[])this.actual, comparator);
        return this;
    }

    @Override
    public LongArrayAssert usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.arrays = new LongArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (LongArrayAssert)this.myself;
    }

    @Override
    public LongArrayAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.arrays = LongArrays.instance();
        return (LongArrayAssert)this.myself;
    }
}

