/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fest.assertions.core.Condition;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Join<T>
extends Condition<T> {
    @VisibleForTesting
    final Collection<Condition<T>> conditions;

    protected Join(Condition<T> ... conditions) {
        this.conditions = Join.listWithoutNulls(conditions);
    }

    private static <T> List<Condition<T>> listWithoutNulls(Condition<T> ... conditions) {
        if (conditions == null) {
            throw Join.conditionsIsNull();
        }
        ArrayList<Condition<T>> list = new ArrayList<Condition<T>>();
        for (Condition<T> condition : conditions) {
            list.add(Join.notNull(condition));
        }
        return list;
    }

    protected Join(Collection<Condition<T>> conditions) {
        this.conditions = Join.listWithoutNulls(conditions);
    }

    private static <T> List<Condition<T>> listWithoutNulls(Collection<Condition<T>> conditions) {
        if (conditions == null) {
            throw Join.conditionsIsNull();
        }
        ArrayList<Condition<T>> list = new ArrayList<Condition<T>>();
        for (Condition<T> condition : conditions) {
            list.add(Join.notNull(condition));
        }
        return list;
    }

    private static NullPointerException conditionsIsNull() {
        return new NullPointerException("The given conditions should not be null");
    }

    private static <T> Condition<T> notNull(Condition<T> condition) {
        if (condition == null) {
            throw new NullPointerException("The given conditions should not have null entries");
        }
        return condition;
    }

    protected final Collection<Condition<T>> conditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }
}

