/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShouldHaveEqualContent
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveEqualContent(File actual, File expected, List<String> diffs) {
        return new ShouldHaveEqualContent(actual, expected, ShouldHaveEqualContent.diffsAsString(diffs));
    }

    public static ErrorMessageFactory shouldHaveEqualContent(InputStream actual, InputStream expected, List<String> diffs) {
        return new ShouldHaveEqualContent(actual, expected, ShouldHaveEqualContent.diffsAsString(diffs));
    }

    private static String diffsAsString(List<String> diffs) {
        StringBuilder b = new StringBuilder();
        for (String diff : diffs) {
            b.append(Systems.LINE_SEPARATOR).append(diff);
        }
        return b.toString();
    }

    private ShouldHaveEqualContent(File actual, File expected, String diffs) {
        super("file:<%s> and file:<%s> do not have equal content:" + diffs, actual, expected);
    }

    private ShouldHaveEqualContent(InputStream actual, InputStream expected, String diffs) {
        super("InputStreams do not have equal content:" + diffs, actual, expected);
    }
}

