/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fest.util.Closeables;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Diff {
    private static final String EOF = "EOF";

    Diff() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> diff(InputStream actual, InputStream expected) throws IOException {
        List<String> list;
        LineNumberReader reader1 = null;
        LineNumberReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{reader1});
            Closeables.close((Closeable[])new Closeable[]{reader2});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{reader1});
        Closeables.close((Closeable[])new Closeable[]{reader2});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> diff(File actual, File expected) throws IOException {
        List<String> list;
        LineNumberReader reader1 = null;
        LineNumberReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{reader1});
            Closeables.close((Closeable[])new Closeable[]{reader2});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{reader1});
        Closeables.close((Closeable[])new Closeable[]{reader2});
        return list;
    }

    private LineNumberReader readerFor(InputStream stream) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(stream)));
    }

    private LineNumberReader readerFor(File file) throws IOException {
        return this.readerFor(new FileInputStream(file));
    }

    private List<String> diff(LineNumberReader reader1, LineNumberReader reader2) throws IOException {
        ArrayList<String> diffs = new ArrayList<String>();
        while (reader2.ready() && reader1.ready()) {
            String line2;
            int lineNumber = reader2.getLineNumber();
            String line1 = reader1.readLine();
            if (Objects.areEqual((Object)line1, (Object)(line2 = reader2.readLine()))) continue;
            diffs.add(this.output(lineNumber, line1, line2));
        }
        if (!reader1.ready() && reader2.ready()) {
            diffs.add(this.output(reader2.getLineNumber(), EOF, reader2.readLine()));
        }
        if (reader1.ready() && !reader2.ready()) {
            diffs.add(this.output(reader1.getLineNumber(), reader1.readLine(), EOF));
        }
        return diffs;
    }

    private String output(int lineNumber, String actual, String expected) {
        return String.format("line:<%d>, expected:<%s> but was:<%s>", lineNumber, expected, actual);
    }
}

