/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Offset;
import org.fest.assertions.error.ShouldBeEqualWithinOffset;
import org.fest.assertions.internal.CommonValidations;
import org.fest.assertions.internal.RealNumbers;
import org.fest.util.ComparisonStrategy;
import org.fest.util.Objects;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doubles
extends RealNumbers<Double> {
    private static final Doubles INSTANCE = new Doubles();

    public static Doubles instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Doubles() {
    }

    public Doubles(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Double zero() {
        return 0.0;
    }

    @Override
    protected Double NaN() {
        return Double.NaN;
    }

    public void assertEqual(AssertionInfo info, Double actual, Double expected, Offset<Double> offset) {
        CommonValidations.checkOffsetIsNotNull(offset);
        Doubles.assertNotNull(info, actual);
        if (Objects.areEqual((Object)actual, (Object)expected)) {
            return;
        }
        if (expected != null && this.isEqualTo(actual, expected, offset)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset));
    }

    @Override
    protected boolean isEqualTo(Double actual, Double expected, Offset<?> offset) {
        return Math.abs(expected - actual) <= ((Number)offset.value).doubleValue();
    }
}

