/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Collection;
import java.util.Comparator;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeEqual;
import org.fest.assertions.error.ShouldBeIn;
import org.fest.assertions.error.ShouldBeInstance;
import org.fest.assertions.error.ShouldBeInstanceOfAny;
import org.fest.assertions.error.ShouldBeSame;
import org.fest.assertions.error.ShouldNotBeEqual;
import org.fest.assertions.error.ShouldNotBeIn;
import org.fest.assertions.error.ShouldNotBeNull;
import org.fest.assertions.error.ShouldNotBeSame;
import org.fest.assertions.internal.Failures;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.StandardComparisonStrategy;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects {
    private static final Objects INSTANCE = new Objects();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private ComparisonStrategy comparisonStrategy;

    public static Objects instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Objects() {
        this((ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public Objects(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertIsInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        this.assertNotNull(info, actual);
        if (type.isInstance(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(actual, type));
    }

    public void assertIsInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info, actual);
        boolean found = false;
        for (Class<?> type : types) {
            if (type == null) {
                String format = "The given array of types:<%s> should not have null elements";
                throw new NullPointerException(String.format(format, ToString.toStringOf(types)));
            }
            if (!type.isInstance(actual)) continue;
            found = true;
            break;
        }
        if (found) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstanceOfAny.shouldBeInstanceOfAny(actual, types));
    }

    private void checkIsNotNullAndIsNotEmpty(Class<?>[] types) {
        if (types == null) {
            throw new NullPointerException("The given array of types should not be null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("The given array of types should not be empty");
        }
    }

    public void assertEqual(AssertionInfo info, Object actual, Object expected) {
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy));
    }

    public void assertNotEqual(AssertionInfo info, Object actual, Object other) {
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(other, actual);
    }

    public void assertNull(AssertionInfo info, Object actual) {
        if (actual == null) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, null, this.comparisonStrategy));
    }

    public void assertNotNull(AssertionInfo info, Object actual) {
        if (actual != null) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeNull.shouldNotBeNull());
    }

    public void assertSame(AssertionInfo info, Object actual, Object expected) {
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSame.shouldBeSame(actual, expected));
    }

    public void assertNotSame(AssertionInfo info, Object actual, Object other) {
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeSame.shouldNotBeSame(actual));
    }

    public void assertIsIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new NullPointerException("The given array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array should not be empty");
        }
    }

    private boolean isActualIn(Object actual, Object[] values) {
        for (Object value : values) {
            if (!this.areEqual(value, actual)) continue;
            return true;
        }
        return false;
    }

    public void assertIsIn(AssertionInfo info, Object actual, Collection<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Collection<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Collection<?> values) {
        if (values == null) {
            throw new NullPointerException("The given collection should not be null");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("The given collection should not be empty");
        }
    }

    private boolean isActualIn(Object actual, Collection<?> values) {
        for (Object value : values) {
            if (!this.areEqual(value, actual)) continue;
            return true;
        }
        return false;
    }
}

