/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractComparableAssert;
import org.fest.assertions.core.NumberAssert;
import org.fest.assertions.internal.Integers;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerAssert
extends AbstractComparableAssert<IntegerAssert, Integer>
implements NumberAssert<Integer> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    protected IntegerAssert(Integer actual) {
        super(actual, IntegerAssert.class);
    }

    @Override
    public IntegerAssert isEqualTo(int expected) {
        this.integers.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public IntegerAssert isNotEqualTo(int other) {
        this.integers.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public IntegerAssert isZero() {
        this.integers.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotZero() {
        this.integers.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isPositive() {
        this.integers.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNegative() {
        this.integers.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotNegative() {
        this.integers.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public IntegerAssert isNotPositive() {
        this.integers.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public IntegerAssert isLessThan(int other) {
        this.integers.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isLessThanOrEqualTo(int other) {
        this.integers.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isGreaterThan(int other) {
        this.integers.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert isGreaterThanOrEqualTo(int other) {
        this.integers.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public IntegerAssert usingComparator(Comparator<? super Integer> customComparator) {
        super.usingComparator(customComparator);
        this.integers = new Integers((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (IntegerAssert)this.myself;
    }

    @Override
    public IntegerAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.integers = Integers.instance();
        return (IntegerAssert)this.myself;
    }
}

