/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongAssert
extends GenericAssert<LongAssert, Long>
implements NumberAssert {
    private static final long ZERO = 0L;

    protected LongAssert(long actual) {
        super(LongAssert.class, actual);
    }

    protected LongAssert(Long actual) {
        super(LongAssert.class, actual);
    }

    @Override
    public LongAssert isEqualTo(long expected) {
        return (LongAssert)this.isEqualTo(Long.valueOf(expected));
    }

    @Override
    public LongAssert isNotEqualTo(long other) {
        return (LongAssert)this.isNotEqualTo(Long.valueOf(other));
    }

    public LongAssert isGreaterThan(long other) {
        if ((Long)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public LongAssert isLessThan(long other) {
        if ((Long)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public LongAssert isGreaterThanOrEqualTo(long other) {
        if ((Long)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public LongAssert isLessThanOrEqualTo(long other) {
        if ((Long)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }

    @Override
    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    @Override
    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }
}

