/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import org.fest.reflect.field.Invoker;

public class StaticFieldType<T> {
    private final String name;
    private final Class<T> type;

    static <T> StaticFieldType<T> newFieldType(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The type of the static field to access should not be null");
        }
        return new StaticFieldType<T>(name, type);
    }

    StaticFieldType(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public Invoker<T> in(Class<?> target) {
        return Invoker.newInvoker(this.name, this.type, target);
    }
}

