/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.wagon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.wagon.WagonCancelledException;
import org.eclipse.aether.connector.wagon.WagonConfigurator;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonTransferListenerAdapter;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.eclipse.aether.util.repository.layout.MavenDefaultLayout;
import org.eclipse.aether.util.repository.layout.RepositoryLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WagonRepositoryConnector
implements RepositoryConnector {
    private static final String PROP_THREADS = "aether.connector.wagon.threads";
    private static final String PROP_CONFIG = "aether.connector.wagon.config";
    private static final String PROP_FILE_MODE = "aether.connector.perms.fileMode";
    private static final String PROP_DIR_MODE = "aether.connector.perms.dirMode";
    private static final String PROP_GROUP = "aether.connector.perms.group";
    private final Logger logger;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final RepositoryLayout layout = new MavenDefaultLayout();
    private final org.eclipse.aether.transfer.TransferListener listener;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final Executor executor;
    private boolean closed;
    private final Map<String, String> checksumAlgos;
    private final Properties headers;
    private static final ExceptionWrapper<MetadataTransfer> METADATA = new ExceptionWrapper<MetadataTransfer>(){

        @Override
        public Exception wrap(MetadataTransfer transfer, Exception e, RemoteRepository repository) {
            MetadataNotFoundException ex = null;
            if ((e = WagonCancelledException.unwrap(e)) instanceof ResourceDoesNotExistException) {
                ex = new MetadataNotFoundException(transfer.getMetadata(), repository);
            } else if (e != null) {
                ex = new MetadataTransferException(transfer.getMetadata(), repository, (Throwable)e);
            }
            transfer.setException(ex);
            return ex;
        }
    };
    private static final ExceptionWrapper<ArtifactTransfer> ARTIFACT = new ExceptionWrapper<ArtifactTransfer>(){

        @Override
        public Exception wrap(ArtifactTransfer transfer, Exception e, RemoteRepository repository) {
            ArtifactNotFoundException ex = null;
            if ((e = WagonCancelledException.unwrap(e)) instanceof ResourceDoesNotExistException) {
                ex = new ArtifactNotFoundException(transfer.getArtifact(), repository);
            } else if (e != null) {
                ex = new ArtifactTransferException(transfer.getArtifact(), repository, (Throwable)e);
            }
            transfer.setException(ex);
            return ex;
        }
    };

    public WagonRepositoryConnector(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, RemoteRepository repository, RepositorySystemSession session, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.logger = logger;
        this.fileProcessor = fileProcessor;
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.repository = repository;
        this.session = session;
        this.listener = session.getTransferListener();
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonRepo.setPermissions(WagonRepositoryConnector.getPermissions(repository.getId(), session));
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        if (this.wagonHint == null || this.wagonHint.length() <= 0) {
            throw new NoRepositoryConnectorException(repository);
        }
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new NoRepositoryConnectorException(repository);
        }
        this.repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);
        this.proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
        this.wagonAuth = this.getAuthenticationInfo(repository, this.repoAuthContext);
        this.wagonProxy = this.getProxy(repository, this.proxyAuthContext);
        int threads = ConfigUtils.getInteger((RepositorySystemSession)session, (int)5, (String[])new String[]{PROP_THREADS, "maven.artifact.threads"});
        this.executor = this.getExecutor(threads);
        this.checksumAlgos = new LinkedHashMap<String, String>();
        this.checksumAlgos.put("SHA-1", ".sha1");
        this.checksumAlgos.put("MD5", ".md5");
        this.headers = new Properties();
        this.headers.put("User-Agent", ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.connector.userAgent"}));
        Map headers = ConfigUtils.getMap((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers"});
        if (headers != null) {
            this.headers.putAll((Map<?, ?>)headers);
        }
    }

    private Executor getExecutor(int threads) {
        if (threads <= 1) {
            return new Executor(){

                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
        return new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private static RepositoryPermissions getPermissions(String repoId, RepositorySystemSession session) {
        String group;
        String dirMode;
        RepositoryPermissions result = null;
        RepositoryPermissions perms = new RepositoryPermissions();
        String suffix = '.' + repoId;
        String fileMode = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{PROP_FILE_MODE + suffix});
        if (fileMode != null) {
            perms.setFileMode(fileMode);
            result = perms;
        }
        if ((dirMode = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{PROP_DIR_MODE + suffix})) != null) {
            perms.setDirectoryMode(dirMode);
            result = perms;
        }
        if ((group = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{PROP_GROUP + suffix})) != null) {
            perms.setGroup(group);
            result = perms;
        }
        return result;
    }

    private AuthenticationInfo getAuthenticationInfo(RemoteRepository repository, final AuthenticationContext authContext) {
        AuthenticationInfo auth = null;
        if (authContext != null) {
            auth = new AuthenticationInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getPrivateKey() {
                    return authContext.get("privateKey.path");
                }

                public String getPassphrase() {
                    return authContext.get("privateKey.passphrase");
                }
            };
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository, final AuthenticationContext authContext) {
        ProxyInfoProvider proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            final ProxyInfo prox = authContext != null ? new ProxyInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getNtlmDomain() {
                    return authContext.get("ntlm.domain");
                }

                public String getNtlmHost() {
                    return authContext.get("ntlm.workstation");
                }
            } : new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            proxy = new ProxyInfoProvider(){

                public ProxyInfo getProxyInfo(String protocol) {
                    return prox;
                }
            };
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws Exception {
        if (!this.headers.isEmpty()) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                setHttpHeaders.invoke((Object)wagon, this.headers);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                this.logger.debug("Could not set user agent for wagon " + wagon.getClass().getName() + ": " + e);
            }
        }
        int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)10000, (String[])new String[]{"aether.connector.connectTimeout"});
        int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout"});
        wagon.setTimeout(Math.max(Math.max(connectTimeout, requestTimeout), 0));
        wagon.setInteractive(ConfigUtils.getBoolean((RepositorySystemSession)this.session, (boolean)false, (String[])new String[]{"aether.interactive"}));
        Object configuration = ConfigUtils.getObject((RepositorySystemSession)this.session, null, (String[])new String[]{"aether.connector.wagon.config." + this.repository.getId()});
        if (configuration != null && this.wagonConfigurator != null) {
            try {
                this.wagonConfigurator.configure(wagon, configuration);
            }
            catch (Exception e) {
                String msg = "Could not apply configuration for " + this.repository.getId() + " to wagon " + wagon.getClass().getName() + ":" + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, (Throwable)e);
                }
                this.logger.warn(msg);
            }
        }
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    private <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private File getTmpFile(String path) {
        File file;
        while ((file = new File(path + ".tmp" + UUID.randomUUID().toString().replace("-", "").substring(0, 16))).exists()) {
        }
        return file;
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        GetTask task;
        String resource;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        artifactDownloads = this.safe(artifactDownloads);
        metadataDownloads = this.safe(metadataDownloads);
        ArrayList<GetTask> tasks = new ArrayList<GetTask>();
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (MetadataDownload metadataDownload : metadataDownloads) {
            resource = this.layout.getPath(metadataDownload.getMetadata()).getPath();
            task = new GetTask(this, resource, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), (Transfer)metadataDownload, METADATA);
            tasks.add(task);
            this.executor.execute(errorForwarder.wrap((Runnable)task));
        }
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            resource = this.layout.getPath(artifactDownload.getArtifact()).getPath();
            task = new GetTask(this, resource, artifactDownload.isExistenceCheck() ? null : artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), (Transfer)artifactDownload, ARTIFACT);
            tasks.add(task);
            this.executor.execute(errorForwarder.wrap((Runnable)task));
        }
        errorForwarder.await();
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTask task;
        String path;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        artifactUploads = this.safe(artifactUploads);
        metadataUploads = this.safe(metadataUploads);
        for (ArtifactUpload artifactUpload : artifactUploads) {
            path = this.layout.getPath(artifactUpload.getArtifact()).getPath();
            task = new PutTask(this, path, artifactUpload.getFile(), (Transfer)artifactUpload, ARTIFACT);
            task.run();
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            path = this.layout.getPath(metadataUpload.getMetadata()).getPath();
            task = new PutTask(this, path, metadataUpload.getFile(), (Transfer)metadataUpload, METADATA);
            task.run();
        }
    }

    public void close() {
        this.closed = true;
        AuthenticationContext.close((AuthenticationContext)this.repoAuthContext);
        AuthenticationContext.close((AuthenticationContext)this.proxyAuthContext);
        Wagon wagon = this.wagons.poll();
        while (wagon != null) {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
            wagon = this.wagons.poll();
        }
        this.shutdown(this.executor);
    }

    private void shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ExceptionWrapper<T> {
        public Exception wrap(T var1, Exception var2, RemoteRepository var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PutTask<T extends Transfer>
    implements Runnable {
        private final T upload;
        private final ExceptionWrapper<T> wrapper;
        private final String path;
        private final File file;
        final /* synthetic */ WagonRepositoryConnector this$0;

        public PutTask(String path, File file, T upload, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.upload = upload;
            this.wrapper = wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.upload.setState(Transfer.State.ACTIVE);
            WagonTransferListenerAdapter wagonListener = null;
            if (this.this$0.listener != null) {
                wagonListener = new WagonTransferListenerAdapter(this.this$0.listener, this.this$0.wagonRepo.getUrl(), this.path, this.file, this.upload.getTrace(), TransferEvent.RequestType.PUT, this.this$0.session);
            }
            try {
                if (this.this$0.listener != null) {
                    TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.INITIATED);
                    this.this$0.listener.transferInitiated(event.build());
                }
                Wagon wagon = this.this$0.pollWagon();
                try {
                    try {
                        wagon.addTransferListener((TransferListener)wagonListener);
                        wagon.put(this.file, this.path);
                    }
                    finally {
                        wagon.removeTransferListener((TransferListener)wagonListener);
                    }
                    this.uploadChecksums(wagon, this.file, this.path);
                    this.wrapper.wrap(this.upload, null, this.this$0.repository);
                    if (this.this$0.listener != null) {
                        TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.SUCCEEDED);
                        this.this$0.listener.transferSucceeded(event.build());
                    }
                }
                finally {
                    this.this$0.wagons.add(wagon);
                }
            }
            catch (Exception e) {
                e = this.wrapper.wrap(this.upload, e, this.this$0.repository);
                if (this.this$0.listener != null) {
                    TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.FAILED);
                    event.setException(e);
                    this.this$0.listener.transferFailed(event.build());
                }
            }
            finally {
                this.upload.setState(Transfer.State.DONE);
            }
        }

        private void uploadChecksums(Wagon wagon, File file, String path) {
            try {
                Map checksums = ChecksumUtils.calc((File)file, this.this$0.checksumAlgos.keySet());
                for (Map.Entry entry : checksums.entrySet()) {
                    this.uploadChecksum(wagon, file, path, (String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                this.this$0.logger.debug("Failed to upload checksums for " + file + ": " + e.getMessage(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadChecksum(Wagon wagon, File file, String path, String algo, Object checksum) {
            block8: {
                try {
                    if (checksum instanceof Exception) {
                        throw (Exception)checksum;
                    }
                    String ext = (String)this.this$0.checksumAlgos.get(algo);
                    String dst = path + ext;
                    String sum = String.valueOf(checksum);
                    if (wagon instanceof StreamingWagon) {
                        byte[] data = sum.getBytes("UTF-8");
                        ((StreamingWagon)wagon).putFromStream((InputStream)new ByteArrayInputStream(data), dst, (long)data.length, -1L);
                        break block8;
                    }
                    File tmpFile = File.createTempFile("wagon" + UUID.randomUUID().toString().replace("-", ""), ext);
                    try {
                        this.this$0.fileProcessor.write(tmpFile, sum);
                        wagon.put(tmpFile, dst);
                    }
                    finally {
                        tmpFile.delete();
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to upload " + algo + " checksum for " + file + ": " + e.getMessage();
                    if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.warn(msg, (Throwable)e);
                    }
                    this.this$0.logger.warn(msg);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetTask<T extends Transfer>
    implements Runnable {
        private final T download;
        private final String path;
        private final File file;
        private final String checksumPolicy;
        private final ExceptionWrapper<T> wrapper;
        final /* synthetic */ WagonRepositoryConnector this$0;

        public GetTask(String path, File file, String checksumPolicy, T download, ExceptionWrapper<T> wrapper) {
            this.this$0 = var1_1;
            this.path = path;
            this.file = file;
            this.checksumPolicy = checksumPolicy;
            this.download = download;
            this.wrapper = wrapper;
        }

        public T getDownload() {
            return this.download;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.download.setState(Transfer.State.ACTIVE);
            WagonTransferListenerAdapter wagonListener = null;
            if (this.this$0.listener != null) {
                wagonListener = new WagonTransferListenerAdapter(this.this$0.listener, this.this$0.wagonRepo.getUrl(), this.path, this.file, this.download.getTrace(), this.file != null ? TransferEvent.RequestType.GET : TransferEvent.RequestType.GET_EXISTENCE, this.this$0.session);
            }
            try {
                if (this.this$0.listener != null) {
                    TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.INITIATED);
                    this.this$0.listener.transferInitiated(event.build());
                }
                File tmp = this.file != null ? this.this$0.getTmpFile(this.file.getPath()) : null;
                Wagon wagon = this.this$0.pollWagon();
                try {
                    if (this.file == null) {
                        if (!wagon.resourceExists(this.path)) {
                            throw new ResourceDoesNotExistException("Could not find " + this.path + " in " + this.this$0.wagonRepo.getUrl());
                        }
                    } else {
                        for (int trial = 1; trial >= 0; --trial) {
                            ChecksumObserver sha1 = new ChecksumObserver("SHA-1");
                            ChecksumObserver md5 = new ChecksumObserver("MD5");
                            try {
                                wagon.addTransferListener((TransferListener)wagonListener);
                                wagon.addTransferListener((TransferListener)md5);
                                wagon.addTransferListener((TransferListener)sha1);
                                this.this$0.fileProcessor.mkdirs(tmp.getParentFile());
                                wagon.get(this.path, tmp);
                            }
                            finally {
                                wagon.removeTransferListener((TransferListener)wagonListener);
                                wagon.removeTransferListener((TransferListener)md5);
                                wagon.removeTransferListener((TransferListener)sha1);
                            }
                            if ("ignore".equals(this.checksumPolicy)) break;
                            try {
                                if (!this.verifyChecksum(wagon, sha1.getActualChecksum(), ".sha1") && !this.verifyChecksum(wagon, md5.getActualChecksum(), ".md5")) {
                                    trial = 0;
                                    throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                                }
                                break;
                            }
                            catch (ChecksumFailureException e) {
                                if (trial <= 0 && "fail".equals(this.checksumPolicy)) {
                                    throw e;
                                }
                                if (this.this$0.listener == null) continue;
                                TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.CORRUPTED);
                                event.setException((Exception)((Object)e));
                                this.this$0.listener.transferCorrupted(event.build());
                                continue;
                            }
                        }
                        this.rename(tmp, this.file);
                    }
                    this.wrapper.wrap(this.download, null, this.this$0.repository);
                    if (this.this$0.listener != null) {
                        TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.SUCCEEDED);
                        this.this$0.listener.transferSucceeded(event.build());
                    }
                }
                finally {
                    if (tmp != null) {
                        tmp.delete();
                    }
                    this.this$0.wagons.add(wagon);
                }
            }
            catch (Exception e) {
                e = this.wrapper.wrap(this.download, e, this.this$0.repository);
                if (this.this$0.listener != null) {
                    TransferEvent.Builder event = wagonListener.newEvent(TransferEvent.EventType.FAILED);
                    event.setException(e);
                    this.this$0.listener.transferFailed(event.build());
                }
            }
            finally {
                this.download.setState(Transfer.State.DONE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean verifyChecksum(Wagon wagon, String actual, String ext) throws ChecksumFailureException {
            tmp = WagonRepositoryConnector.access$300(this.this$0, this.file.getPath() + ext);
            try {
                wagon.get(this.path + ext, tmp);
            }
            catch (ResourceDoesNotExistException e) {
                var6_8 = false;
                tmp.delete();
                return var6_8;
            }
            catch (WagonException e) {
                throw new ChecksumFailureException((Throwable)e);
            }
            ** try [egrp 3[TRYBLOCK] [2 : 91->101)] { 
lbl-1000:
            // 1 sources

            {
                expected = ChecksumUtils.read((File)tmp);
            }
lbl16:
            // 1 sources

            catch (IOException e) {
                if (!tmp.exists()) {
                    expected = "";
                }
                throw new ChecksumFailureException((Throwable)e);
            }
            if (expected.equalsIgnoreCase(actual)) {
                try {
                    this.rename(tmp, new File(this.file.getPath() + ext));
                }
                catch (IOException e) {
                    WagonRepositoryConnector.access$700(this.this$0).debug("Failed to write checksum file " + this.file.getPath() + ext + ": " + e.getMessage(), (Throwable)e);
                }
            } else {
                throw new ChecksumFailureException(expected, actual);
                finally {
                    tmp.delete();
                }
            }
            return true;
        }

        private void rename(File from, File to) throws IOException {
            if (!from.exists()) {
                this.this$0.fileProcessor.write(to, "");
            } else {
                this.this$0.fileProcessor.move(from, to);
            }
        }
    }
}

