/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.gimap;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import java.io.IOException;
import org.eclipse.angus.mail.gimap.GmailFolder;
import org.eclipse.angus.mail.gimap.protocol.GmailProtocol;
import org.eclipse.angus.mail.iap.ProtocolException;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.eclipse.angus.mail.imap.protocol.IMAPProtocol;
import org.eclipse.angus.mail.imap.protocol.ListInfo;

public class GmailStore
extends IMAPStore {
    public GmailStore(Session session, URLName url) {
        this(session, url, "gimap", true);
    }

    protected GmailStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, true);
    }

    protected boolean protocolConnect(String host, int pport, String user, String password) throws MessagingException {
        if (host == null) {
            host = "imap.gmail.com";
        }
        return super.protocolConnect(host, pport, user, password);
    }

    protected IMAPProtocol newIMAPProtocol(String host, int port) throws IOException, ProtocolException {
        return new GmailProtocol(this.name, host, port, this.session.getProperties(), this.isSSL, this.logger);
    }

    protected IMAPFolder newIMAPFolder(String fullName, char separator, Boolean isNamespace) {
        return new GmailFolder(fullName, separator, this, isNamespace);
    }

    protected IMAPFolder newIMAPFolder(ListInfo li) {
        return new GmailFolder(li, this);
    }
}

