/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.QueryCompUtil;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ColumnBindingMetaData
implements IResultMetaData {
    List<Binding> bindingList = new ArrayList<Binding>();
    Map aliasMap;

    public ColumnBindingMetaData(IBaseQueryDefinition queryDefn, IResultClass rsClass) throws DataException {
        ArrayList<Binding> presentBindings = new ArrayList<Binding>(queryDefn.getBindings().values());
        if (((QueryDefinition)queryDefn).needAutoBinding() && rsClass != null) {
            ResultMetaData metaData = new ResultMetaData(rsClass);
            this.aliasMap = new HashMap();
            int columnCount = metaData.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                int colIndex = i + 1;
                try {
                    String colName = metaData.getColumnName(colIndex);
                    if (!this.isTemp(colName)) {
                        String alias = metaData.getColumnAlias(colIndex);
                        if (alias != null) {
                            this.aliasMap.put(colIndex, alias);
                        }
                        ScriptExpression baseExpr = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)colName), metaData.getColumnType(colIndex));
                        Binding binding = new Binding(colName, baseExpr);
                        binding.setDisplayName(metaData.getColumnLabel(colIndex));
                        IBinding found = this.findBinding(binding, presentBindings);
                        if (found != null && found.getDataType() == -1) {
                            presentBindings.remove(found);
                        }
                        this.bindingList.add(binding);
                    }
                }
                catch (BirtException birtException) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.bindingList.addAll(presentBindings);
    }

    private IBinding findBinding(IBinding binding, List<Binding> presentBindings) throws DataException {
        for (IBinding iBinding : presentBindings) {
            if (!this.isSameBinding(iBinding, binding)) continue;
            return iBinding;
        }
        return null;
    }

    private boolean isSameBinding(IBinding b1, IBinding b2) throws DataException {
        if (!(QueryCompUtil.isTwoExpressionEqual(b1.getExpression(), b2.getExpression(), true) && QueryCompUtil.isEqualString(b1.getAggrFunction(), b2.getAggrFunction()) && QueryCompUtil.isTwoExpressionEqual(b1.getFilter(), b2.getFilter(), true) && b1.getAggregatOns().size() == b2.getAggregatOns().size())) {
            return false;
        }
        int i = 0;
        while (i < b1.getAggregatOns().size()) {
            if (!QueryCompUtil.isEqualString(b1.getAggregatOns().get(i).toString(), b2.getAggregatOns().get(i).toString())) {
                return false;
            }
            ++i;
        }
        if (b1.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        i = 0;
        while (i < b1.getArguments().size()) {
            if (!QueryCompUtil.isTwoExpressionEqual(b1.getArguments().get(i), b2.getArguments().get(i), true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isTemp(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E") || "_$$_dte_inner_row_id_$$_".equals(name);
    }

    @Override
    public String getColumnAlias(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        if (this.aliasMap == null) {
            return null;
        }
        return this.aliasMap.get(index) == null ? null : this.aliasMap.get(index).toString();
    }

    @Override
    public int getColumnCount() {
        return this.bindingList.size();
    }

    @Override
    public String getColumnLabel(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getDisplayName();
    }

    @Override
    public String getColumnName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getBindingName();
    }

    @Override
    public String getColumnNativeTypeName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        return null;
    }

    @Override
    public int getColumnType(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getDataType();
    }

    @Override
    public String getColumnTypeName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return DataType.getName((int)binding.getDataType());
    }

    @Override
    public boolean isComputedColumn(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        return false;
    }
}

