/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ImageDataValidator
extends AbstractElementValidator {
    private static final ImageDataValidator instance = new ImageDataValidator();

    public static ImageDataValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement image) {
        String name;
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        String refType = image.getStringProperty(module, "source");
        if ("expr".equalsIgnoreCase(refType)) {
            String valueExpr = image.getStringProperty(module, "valueExpr");
            if (StringUtil.isEmpty(valueExpr)) {
                list.add(new SemanticError(image, "Error.DesignParserException.INVALID_IMAGEREF_EXPR_VALUE"));
            }
        } else if ("url".equalsIgnoreCase(refType) || "file".equalsIgnoreCase(refType)) {
            String uri = image.getStringProperty(module, "uri");
            if (StringUtil.isEmpty(uri)) {
                list.add(new SemanticError(image, "Error.DesignParserException.INVALID_IMAGE_URL_VALUE"));
            }
        } else if ("embed".equalsIgnoreCase(refType) && StringUtil.isEmpty(name = image.getStringProperty(module, "imageName"))) {
            list.add(new SemanticError(image, "Error.DesignParserException.INVALID_IMAGE_NAME_VALUE"));
        }
        return list;
    }
}

