/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageHintWriterV3
implements IPageHintWriter {
    protected IDocArchiveWriter writer;
    protected RAOutputStream indexStream;
    protected RAOutputStream hintsStream;
    private ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream();
    private DataOutputStream hintBuffer = new DataOutputStream(this.writeBuffer);

    public PageHintWriterV3(IDocArchiveWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.hintsStream = writer.createRandomAccessStream("/pages");
            this.hintsStream.writeInt(3);
            this.indexStream = writer.createRandomAccessStream("/pages_index");
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void writePageHint(IPageHint pageHint) throws IOException {
        long offset = this.hintsStream.getOffset();
        this.indexStream.seek(pageHint.getPageNumber() * 8L);
        this.indexStream.writeLong(offset);
        this.writeBuffer.reset();
        this.writePageHint(this.hintBuffer, pageHint);
        this.hintsStream.write(this.writeBuffer.toByteArray());
    }

    @Override
    public void writeTotalPage(long totalPage) throws IOException {
        this.indexStream.seek(0L);
        this.indexStream.writeLong(totalPage);
    }

    protected void writePageHint(DataOutputStream out, IPageHint hint) throws IOException {
        IOUtil.writeLong((DataOutputStream)out, (long)hint.getPageNumber());
        IOUtil.writeLong((DataOutputStream)out, (long)hint.getOffset());
        int sectionCount = hint.getSectionCount();
        IOUtil.writeInt((OutputStream)out, (int)sectionCount);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = hint.getSection(i);
            this.writeInstanceIndex(out, section.starts);
            this.writeInstanceIndex(out, section.ends);
            ++i;
        }
        int hintSize = hint.getUnresolvedRowCount();
        IOUtil.writeInt((OutputStream)out, (int)hintSize);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = hint.getUnresolvedRowHint(i2);
            rowHint.writeObject(out);
            ++i2;
        }
    }

    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            return;
        }
        IOUtil.writeInt((OutputStream)out, (int)indexes.length);
        int i = 0;
        while (i < indexes.length) {
            IOUtil.writeString((DataOutputStream)out, (String)indexes[i].getInstanceID().toString());
            IOUtil.writeLong((DataOutputStream)out, (long)indexes[i].getOffset());
            ++i;
        }
    }

    @Override
    public void writePageVariables(Collection<PageVariable> variables) throws IOException {
        throw new IOException("unsupported operation: writePageVariables");
    }
}

