/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.IReportletDocument;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ReportletQuery;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class ReportBodyExecutor
extends ContainerExecutor {
    private Report reportDesign;
    private int nextItem;
    ReportletBodyExecutor reportlet;

    ReportBodyExecutor(ExecutorManager manager, Fragment fragment) {
        super(manager, -1);
        this.reportDesign = this.context.getReport();
        this.reader = manager.getReportReader();
        this.nextItem = 0;
        if (fragment == null) {
            if (!this.reader.isEmpty()) {
                this.nextOffset = this.reader.getRootOffset();
            }
        } else {
            this.setFragment(fragment);
            Object[][] sections = fragment.getSections();
            if (sections != null && sections.length > 0) {
                Object[] edges = sections[0];
                if (edges[0] == Segment.LEFT_MOST_EDGE) {
                    if (!this.reader.isEmpty()) {
                        this.nextOffset = this.reader.getRootOffset();
                    }
                } else {
                    InstanceIndex leftEdge = (InstanceIndex)edges[0];
                    if (leftEdge.getOffset() == -1L && !this.reader.isEmpty()) {
                        this.nextOffset = this.reader.getRootOffset();
                    }
                }
            }
        }
        this.content = this.report.getRoot();
        this.initializeReportlet();
    }

    public void close() {
        if (this.reportlet != null) {
            try {
                this.reportlet.closeReportletQueries();
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
            this.reportlet = null;
        }
        this.nextItem = 0;
        super.close();
    }

    public IBaseResultSet[] getQueryResults() {
        if (this.reportlet != null) {
            return this.reportlet.getQueryResults();
        }
        return super.getQueryResults();
    }

    public IContent execute() {
        if (this.reportlet != null) {
            try {
                this.reportlet.openReportletQueries();
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
        return this.content;
    }

    protected InstanceID getInstanceID() {
        return null;
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        if (this.reportlet != null) {
            return this.reportlet.createExecutor(offset);
        }
        int itemCount = this.reportDesign.getContentCount();
        if (this.nextItem < itemCount) {
            ReportItemDesign itemDesign = this.reportDesign.getContent(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, itemDesign, offset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        if (this.reportlet != null) {
            this.reportlet.skipToExecutor(id, offset);
            return;
        }
        int itemCount = this.reportDesign.getContentCount();
        long designId = id.getComponentID();
        int i = 0;
        while (i < itemCount) {
            ReportItemDesign itemDesign = this.reportDesign.getContent(i);
            if (designId == itemDesign.getID()) {
                this.nextItem = i;
                return;
            }
            ++i;
        }
        this.nextItem = itemCount;
    }

    protected void doExecute() throws Exception {
    }

    void initializeReportlet() {
        IReportDocument document;
        if (this.reportlet == null && (document = this.context.getReportDocument()) instanceof IReportletDocument) {
            IReportletDocument reportletDocument = (IReportletDocument)document;
            try {
                long id;
                InstanceID iid;
                if (reportletDocument.isReporltetDocument() && (iid = reportletDocument.getReportletInstanceID()) != null && (id = iid.getComponentID()) != -1L) {
                    this.reportlet = new ReportletBodyExecutor(this.context, iid);
                }
            }
            catch (IOException ex) {
                this.context.addException(new EngineException(ex.getLocalizedMessage(), ex));
            }
        }
    }

    private class ReportletBodyExecutor {
        boolean hasNext = true;
        ReportItemDesign reportletDesign;
        ReportletQuery reportletQuery;

        ReportletBodyExecutor(ExecutionContext context, InstanceID iid) {
            long id = iid.getComponentID();
            this.reportletDesign = (ReportItemDesign)context.getReport().getReportItemByID(id);
            this.reportletQuery = new ReportletQuery(context, iid);
        }

        ReportItemExecutor createExecutor(long offset) throws Exception {
            if (this.hasNext) {
                this.hasNext = false;
                return ReportBodyExecutor.this.manager.createExecutor(ReportBodyExecutor.this, this.reportletDesign, offset);
            }
            return null;
        }

        void skipToExecutor(InstanceID id, long offset) throws Exception {
            assert (id.getComponentID() == this.reportletDesign.getID());
        }

        void openReportletQueries() throws BirtException {
            this.reportletQuery.openReportletQueries();
        }

        void closeReportletQueries() throws BirtException {
            this.reportletQuery.closeReportletQueries();
        }

        public IBaseResultSet[] getQueryResults() {
            return this.reportletQuery.getQueryResults();
        }
    }
}

