/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.InputStream;
import java.util.Locale;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationAxisImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationPlotImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemPresentationInfo;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ChartReportItemPresentationProxy
implements IReportItemPresentation {
    private IReportItemPresentation impl;
    private IReportItemPresentationInfo info;

    public void init(IReportItemPresentationInfo info) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
        this.impl = this.createImpl(info);
        this.impl.init(info);
    }

    protected IReportItemPresentation createImpl(IReportItemPresentationInfo info) {
        ExtendedItemHandle modelHandle = info.getModelObject();
        if (ChartCubeUtil.isInXTabMeasureCell(modelHandle)) {
            if (ChartCubeUtil.isPlotChart(modelHandle)) {
                return new ChartReportItemPresentationPlotImpl();
            }
            if (ChartCubeUtil.isAxisChart(modelHandle)) {
                return new ChartReportItemPresentationAxisImpl();
            }
        }
        return ChartReportItemUtil.instanceReportItemPresentation(modelHandle, info);
    }

    public void deserialize(InputStream istream) {
        assert (this.impl != null);
        this.impl.deserialize(istream);
    }

    public void finish() {
        assert (this.impl != null);
        this.impl.finish();
    }

    public String getImageMIMEType() {
        assert (this.impl != null);
        return this.impl.getImageMIMEType();
    }

    public int getOutputType() {
        assert (this.impl != null);
        return this.impl.getOutputType();
    }

    public Size getSize() {
        assert (this.impl != null);
        return this.impl.getSize();
    }

    public Object onRowSets(IBaseResultSet[] results) throws BirtException {
        assert (this.impl != null);
        return this.impl.onRowSets(results);
    }

    public IReportItemPresentationInfo getPresentationConfig() {
        return this.info;
    }

    public Object onRowSets(IRowSet[] rowSets) throws BirtException {
        assert (false);
        return null;
    }

    public void setActionHandler(IHTMLActionHandler ah) {
        assert (false);
    }

    public void setApplicationClassLoader(ClassLoader loader) {
        assert (false);
    }

    public void setDynamicStyle(IStyle style) {
        assert (false);
    }

    public void setExtendedItemContent(IContent content) {
        assert (false);
    }

    public void setLocale(Locale locale) {
        assert (false);
    }

    public void setModelObject(ExtendedItemHandle modelHandle) {
        assert (false);
    }

    public void setOutputFormat(String outputFormat) {
        assert (false);
    }

    public void setReportQueries(IDataQueryDefinition[] queries) {
        assert (false);
    }

    public void setResolution(int dpi) {
        assert (false);
    }

    public void setScriptContext(IReportContext context) {
        assert (false);
    }

    public void setSupportedImageFormats(String supportedImageFormats) {
        assert (false);
    }
}

