/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.core.data.DimLevel;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OlapExpressionCompiler {
    OlapExpressionCompiler() {
    }

    public static String getReferencedMeasure(String expr) {
        if (expr == null) {
            return null;
        }
        try {
            Context cx = Context.enter();
            CompilerEnvirons ce = new CompilerEnvirons();
            Parser p = new Parser(ce, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(expr, null, 0);
            String string = OlapExpressionCompiler.getScriptObjectName((Node)tree, "measure");
            return string;
        }
        finally {
            Context.exit();
        }
    }

    public static Set<IDimLevel> getReferencedDimLevel(String expr) throws CoreException {
        if (expr == null) {
            return new HashSet<IDimLevel>();
        }
        try {
            HashSet<IDimLevel> result = new HashSet<IDimLevel>();
            Context cx = Context.enter();
            CompilerEnvirons ce = new CompilerEnvirons();
            Parser p = new Parser(ce, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(expr, null, 0);
            OlapExpressionCompiler.populateDimLevels(null, (Node)tree, result);
            HashSet<IDimLevel> hashSet = result;
            return hashSet;
        }
        finally {
            Context.exit();
        }
    }

    private static void populateDimLevels(Node grandpa, Node n, Set<IDimLevel> result) throws CoreException {
        if (n == null) {
            return;
        }
        if (n.getFirstChild() != null && (n.getType() == 33 || n.getType() == 36)) {
            if (n.getFirstChild().getFirstChild() != null && (n.getFirstChild().getFirstChild().getType() == 33 || n.getFirstChild().getFirstChild().getType() == 36)) {
                String attr;
                String levelName;
                String dimName;
                DimLevel dimLevel;
                Node dim = n.getFirstChild().getFirstChild();
                if ("dimension".equals(dim.getFirstChild().getString()) && !result.contains(dimLevel = new DimLevel(dimName = dim.getLastChild().getString(), levelName = dim.getNext().getString(), attr = n.getLastChild().getString()))) {
                    result.add(dimLevel);
                }
            } else if (n.getFirstChild() != null && n.getFirstChild().getType() == 39 && "dimension".equals(n.getFirstChild().getString()) && n.getLastChild() != null && n.getNext() != null) {
                DimLevel dimLevel;
                String dimName = n.getLastChild().getString();
                String levelName = n.getNext().getString();
                String attr = null;
                if (grandpa != null && grandpa.getNext() != null && grandpa.getNext().getType() == 41) {
                    attr = grandpa.getNext().getString();
                }
                if (!result.contains(dimLevel = new DimLevel(dimName, levelName, attr))) {
                    result.add(dimLevel);
                }
            }
        }
        OlapExpressionCompiler.populateDimLevels(grandpa, n.getFirstChild(), result);
        OlapExpressionCompiler.populateDimLevels(grandpa, n.getLastChild(), result);
    }

    private static String getScriptObjectName(Node n, String objectName) {
        if (n == null) {
            return null;
        }
        String result = null;
        if (n.getType() == 39 && objectName.equals(n.getString())) {
            Node dimNameNode = n.getNext();
            if (dimNameNode == null || dimNameNode.getType() != 41) {
                return null;
            }
            return dimNameNode.getString();
        }
        result = OlapExpressionCompiler.getScriptObjectName(n.getFirstChild(), objectName);
        if (result == null) {
            result = OlapExpressionCompiler.getScriptObjectName(n.getLastChild(), objectName);
        }
        return result;
    }
}

