/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.ObjectSecurity;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ResultObjectUtil {
    private int columnCount;
    private Class[] typeArray;
    private IResultClass rsMetaData;
    private DataEngineSession session;

    public static ResultObjectUtil newInstance(IResultClass rsMetaData, DataEngineSession session) {
        ResultObjectUtil instance = new ResultObjectUtil();
        int length = rsMetaData.getFieldCount();
        instance.typeArray = new Class[length];
        int i = 0;
        while (i < length) {
            try {
                instance.typeArray[i] = rsMetaData.getFieldValueClass(i + 1);
            }
            catch (DataException dataException) {}
            ++i;
        }
        instance.columnCount = rsMetaData.getFieldCount();
        instance.rsMetaData = rsMetaData;
        instance.session = session;
        return instance;
    }

    private ResultObjectUtil() {
    }

    public ResultObject newResultObject(Object[] rowData) {
        return new ResultObject(this.rsMetaData, rowData);
    }

    public IResultObject[] readData(InputStream bis, ClassLoader classLoader, int length) throws IOException, DataException {
        IResultObject[] rowDatas = new ResultObject[length];
        int i = 0;
        while (i < length) {
            int readSize;
            if (this.session.getStopSign().isStopped()) break;
            int rowLen = IOUtil.readInt(bis);
            byte[] rowDataBytes = new byte[rowLen];
            int totalSize = readSize = bis.read(rowDataBytes);
            while (readSize > 0 && totalSize < rowLen) {
                readSize = bis.read(rowDataBytes, totalSize, rowLen - totalSize);
                totalSize += readSize;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(rowDataBytes);
            DataInputStream dis = new DataInputStream(bais);
            Object[] obs = new Object[this.columnCount];
            int j = 0;
            while (j < this.columnCount) {
                Class fieldType = this.typeArray[j];
                if (dis.readByte() == 0) {
                    obs[j] = null;
                } else if (fieldType.equals(Integer.class)) {
                    obs[j] = dis.readInt();
                } else if (fieldType.equals(Double.class)) {
                    obs[j] = new Double(dis.readDouble());
                } else if (fieldType.equals(BigDecimal.class)) {
                    obs[j] = new BigDecimal(dis.readUTF());
                } else if (fieldType.equals(Time.class)) {
                    obs[j] = new Time(dis.readLong());
                } else if (fieldType.equals(Timestamp.class)) {
                    obs[j] = new Timestamp(dis.readLong());
                } else if (fieldType.equals(Date.class)) {
                    obs[j] = new Date(dis.readLong());
                } else if (java.util.Date.class.isAssignableFrom(fieldType)) {
                    obs[j] = new java.util.Date(dis.readLong());
                } else if (fieldType.equals(Boolean.class)) {
                    obs[j] = dis.readBoolean();
                } else if (fieldType.equals(String.class)) {
                    obs[j] = IOUtil.readString(dis);
                } else if (fieldType.equals(IClob.class) || fieldType.equals(Clob.class)) {
                    obs[j] = IOUtil.readString(dis);
                } else if (fieldType.equals(IBlob.class) || fieldType.equals(Blob.class)) {
                    int len = IOUtil.readInt(dis);
                    if (len == 0) {
                        obs[j] = null;
                    } else {
                        byte[] bytes = new byte[len];
                        dis.read(bytes);
                        obs[j] = bytes;
                    }
                } else if (fieldType.equals(Object.class) || fieldType.equals(DataType.getClass(0))) {
                    ObjectInputStream ois = null;
                    ois = classLoader != null ? ObjectSecurity.createObjectInputStream(dis, classLoader) : ObjectSecurity.createObjectInputStream(dis);
                    try {
                        obs[j] = ObjectSecurity.readObject(ois);
                    }
                    catch (Exception exception) {}
                    ois.close();
                } else {
                    throw new DataException("data.engine.BadDataType", fieldType.toString());
                }
                ++j;
            }
            rowDatas[i] = this.newResultObject(obs);
            rowDataBytes = null;
            dis = null;
            bais = null;
            ++i;
        }
        return rowDatas;
    }

    public void writeData(OutputStream bos, IResultObject[] resultObjects, int length) throws IOException, DataException {
        int i = 0;
        while (i < length) {
            this.writeData(bos, resultObjects[i]);
            if (this.session.getStopSign().isStopped()) {
                return;
            }
            ++i;
        }
    }

    public void writeData(OutputStream bos, IResultObject resultObject) throws IOException, DataException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int j = 0;
        while (j < this.columnCount) {
            Object fieldValue = null;
            try {
                fieldValue = resultObject.getFieldValue(j + 1);
            }
            catch (DataException dataException) {}
            if (fieldValue == null) {
                dos.writeByte(0);
            } else {
                dos.writeByte(1);
                Class fieldType = this.typeArray[j];
                if (fieldType.equals(Integer.class)) {
                    dos.writeInt((Integer)this.convert(fieldValue, 2));
                } else if (fieldType.equals(Double.class)) {
                    dos.writeDouble((Double)this.convert(fieldValue, 3));
                } else if (fieldType.equals(BigDecimal.class)) {
                    dos.writeUTF(((BigDecimal)this.convert(fieldValue, 4)).toString());
                } else if (java.util.Date.class.isAssignableFrom(fieldType)) {
                    dos.writeLong(((java.util.Date)this.convert(fieldValue, 6)).getTime());
                } else if (fieldType.equals(Boolean.class)) {
                    dos.writeBoolean((Boolean)this.convert(fieldValue, 1));
                } else if (fieldType.equals(String.class)) {
                    IOUtil.writeString(dos, fieldValue.toString());
                } else if (fieldType.equals(IClob.class) || fieldType.equals(Clob.class)) {
                    IOUtil.writeString(dos, fieldValue.toString());
                } else if (fieldType.equals(IBlob.class) || fieldType.equals(Blob.class)) {
                    byte[] bytes = (byte[])fieldValue;
                    if (bytes == null || bytes.length == 0) {
                        IOUtil.writeInt(dos, 0);
                    } else {
                        IOUtil.writeInt(dos, bytes.length);
                        dos.write((byte[])fieldValue);
                    }
                } else if (fieldType.equals(Object.class) || fieldType.equals(DataType.getClass(0))) {
                    if (!(fieldValue instanceof Serializable)) {
                        throw new DataException("data.engine.NotSerializableClass", fieldValue.getClass().getName());
                    }
                    ObjectOutputStream oo = ObjectSecurity.createObjectOutputStream(dos);
                    oo.writeObject(fieldValue);
                    oo.close();
                } else {
                    throw new DataException("data.engine.BadDataType", fieldType.toString());
                }
            }
            ++j;
        }
        dos.flush();
        byte[] rowsDataBytes = baos.toByteArray();
        IOUtil.writeInt(bos, rowsDataBytes.length);
        bos.write(rowsDataBytes);
        rowsDataBytes = null;
        dos = null;
        baos = null;
    }

    private Object convert(Object o, int type) throws DataException {
        try {
            return DataTypeUtil.convert(o, type);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

