/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ICubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;

public class FacttableRow
implements IFacttableRow {
    private MeasureInfo[] measureInfo;
    private Object[] measureValues;
    private ICubeDimensionReader cubeDimensionReader;
    private IDataSet4Aggregation.MetaInfo metaInfo;
    private int[] dimPos;

    FacttableRow(MeasureInfo[] measureInfo, ICubeDimensionReader cubeDimensionReader, IDataSet4Aggregation.MetaInfo metaInfo) {
        this.measureInfo = measureInfo;
        this.cubeDimensionReader = cubeDimensionReader;
        this.metaInfo = metaInfo;
    }

    void setMeasure(Object[] measureValues) {
        this.measureValues = measureValues;
    }

    public Object getMeasureValue(String measureName) throws DataException {
        int i = 0;
        while (i < this.measureInfo.length) {
            if (this.measureInfo[i].getMeasureName().equals(measureName)) {
                return this.measureValues[i];
            }
            ++i;
        }
        return null;
    }

    public void setDimPos(int[] dimPos) {
        this.dimPos = dimPos;
    }

    public Object getLevelAttributeValue(String dimensionName, String levelName, String attribute) throws IOException, DataException {
        if (this.cubeDimensionReader == null || this.metaInfo == null) {
            return null;
        }
        try {
            Member member = this.getLevelMember(dimensionName, levelName);
            int attributeIndex = this.getAttributeIndex(dimensionName, levelName, attribute);
            if (member != null && attributeIndex >= 0) {
                return member.getAttributes()[attributeIndex];
            }
            return null;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public Object[] getLevelKeyValue(String dimensionName, String levelName) throws IOException, DataException {
        block4: {
            try {
                if (this.cubeDimensionReader != null && this.metaInfo != null) break block4;
                return null;
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        Member member = this.getLevelMember(dimensionName, levelName);
        if (member != null) {
            return member.getKeyValues();
        }
        return null;
    }

    private Member getLevelMember(String dimensionName, String levelName) throws BirtException, IOException {
        int dimIndex = this.getDimensionIndex(dimensionName);
        if (dimIndex < 0) {
            throw new DataException("data.olap.DimensionNotExist", dimensionName);
        }
        int levelIndex = this.getLevelIndex(dimensionName, levelName);
        if (levelIndex < 0) {
            throw new DataException("data.olap.levelNameNotFound", String.valueOf(dimensionName) + "." + levelName);
        }
        return this.cubeDimensionReader.getLevelMember(dimIndex, levelIndex, this.dimPos[dimIndex]);
    }

    private int getAttributeIndex(String dimensionName, String levelName, String attributeName) throws DataException {
        int dimIndex = this.getDimensionIndex(dimensionName);
        if (dimIndex < 0) {
            throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.DimensionNotExist")) + dimensionName);
        }
        int levelIndex = this.getLevelIndex(dimensionName, levelName);
        if (levelIndex < 0) {
            throw new DataException("data.olap.levelNameNotFound", String.valueOf(dimensionName) + "." + levelName);
        }
        String[] attributeNames = this.metaInfo.getAttributeNames(dimIndex, levelIndex);
        if (attributeNames == null || attributeNames.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeNames[i] != null && attributeNames[i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getDimensionIndex(String dimensionName) {
        return this.metaInfo.getDimensionIndex(dimensionName);
    }

    private int getLevelIndex(String dimensionName, String levelName) {
        return this.metaInfo.getLevelIndex(dimensionName, levelName);
    }
}

