/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ComputedColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ConditionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ExpressionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.FilterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.InputParamBindingAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.JointDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ParameterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortHintAdapter;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.CalculationArgumentHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.mozilla.javascript.Scriptable;

public class ModelAdapter
implements IModelAdapter {
    private static Logger logger = Logger.getLogger(ModelAdapter.class.getName());
    DataSessionContext context;

    public ModelAdapter(DataSessionContext context) {
        this.context = context;
    }

    public BaseDataSourceDesign adaptDataSource(DataSourceHandle handle) throws BirtException {
        if (handle instanceof OdaDataSourceHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            return new OdaDataSourceAdapter((OdaDataSourceHandle)handle, propBindingScope, this.context.getDataEngineContext(), this);
        }
        if (handle instanceof ScriptDataSourceHandle) {
            return new ScriptDataSourceAdapter((ScriptDataSourceHandle)handle);
        }
        logger.fine("handle type: " + (handle == null ? "" : handle.getClass().getName()));
        return null;
    }

    public BaseDataSetDesign adaptDataSet(DataSetHandle handle) throws BirtException {
        BaseDataSetDesign design = null;
        if (handle instanceof OdaDataSetHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            design = new OdaDataSetAdapter((OdaDataSetHandle)handle, propBindingScope, this, this.context.getDataEngineContext());
        }
        if (handle instanceof ScriptDataSetHandle) {
            design = new ScriptDataSetAdapter((ScriptDataSetHandle)handle, this);
        }
        if (handle instanceof JointDataSetHandle) {
            design = new JointDataSetAdapter((JointDataSetHandle)handle, this);
        }
        if (design != null) {
            if (handle.getACLExpression() != null) {
                design.setDataSetACL(this.adaptExpression((Expression)handle.getACLExpression().getValue()));
            }
            if (handle.getRowACLExpression() != null) {
                design.setRowACL(this.adaptExpression((Expression)handle.getRowACLExpression().getValue()));
            }
            Iterator columnHintIterator = handle.columnHintsIterator();
            while (columnHintIterator.hasNext()) {
                ColumnHintHandle ch = (ColumnHintHandle)columnHintIterator.next();
                design.setDataSetColumnACL(ch.getColumnName(), this.adaptExpression((Expression)ch.getACLExpression().getValue()));
            }
        }
        if (design != null) {
            design.setCompareLocale(handle.getLocale());
            design.setNullsOrdering(handle.getNullsOrdering());
            design.setNeedCache(handle.needsCache());
        }
        logger.fine("handle type: " + (handle == null ? "" : handle.getClass().getName()));
        return design;
    }

    public ConditionalExpression adaptConditionalExpression(String mainExpr, String operator, String operand1, String operand2) {
        return new ConditionAdapter(mainExpr, operator, operand1, operand2);
    }

    public ScriptExpression adaptExpression(Expression expr, String dataType) {
        if (expr == null || expr.getStringExpression() == null) {
            return null;
        }
        ScriptExpression jsExpr = new ExpressionAdapter(expr, dataType);
        if ("constant".equals(expr.getType())) {
            jsExpr = new ScriptExpression(JavascriptEvalUtil.transformToJsExpression(expr.getStringExpression()));
            jsExpr.setConstant(true);
            jsExpr.setConstantValue(expr.getExpression());
        }
        return jsExpr;
    }

    public FilterDefinition adaptFilter(FilterConditionHandle modelFilter) {
        try {
            return new FilterAdapter((IModelAdapter)this, modelFilter);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSortHint(SortHintHandle sortHint) {
        try {
            return new SortHintAdapter(this, sortHint);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public GroupDefinition adaptGroup(GroupHandle groupHandle) {
        try {
            return new GroupAdapter(this, groupHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSort(SortKeyHandle sortHandle) {
        try {
            return new SortAdapter(this, sortHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSort(Expression expr, String direction) {
        try {
            return new SortAdapter(this, expr, direction);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public ParameterDefinition adaptParameter(DataSetParameterHandle paramHandle) {
        return new ParameterAdapter(paramHandle);
    }

    public InputParameterBinding adaptInputParamBinding(ParamBindingHandle modelHandle) {
        try {
            return new InputParamBindingAdapter(this, modelHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public ColumnDefinition ColumnAdaptor(ResultSetColumnHandle modelColumn) {
        return new ColumnAdapter(modelColumn);
    }

    public ComputedColumn adaptComputedColumn(ComputedColumnHandle modelHandle) throws AdapterException {
        return new ComputedColumnAdapter(this, modelHandle);
    }

    public IBinding adaptBinding(ComputedColumnHandle handle) {
        block4: {
            try {
                if (handle != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        Binding result = new Binding(handle.getName());
        if (handle.getExpression() != null) {
            ScriptExpression expr = this.adaptExpression((Expression)handle.getExpressionProperty("expression").getValue(), handle.getDataType());
            expr.setGroupName(handle.getAggregateOn());
            result.setExpression(expr);
        }
        result.setDisplayName(handle.getExternalizedValue("displayNameID", "displayName", this.context.getDataEngineContext().getLocale()));
        result.setTimeFunction(this.adaptTimeFunction(handle));
        result.setDataType(DataAdapterUtil.adaptModelDataType(handle.getDataType()));
        result.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(handle.getAggregateFunction()));
        result.setFilter(handle.getFilterExpression() == null ? null : this.adaptExpression((Expression)handle.getExpressionProperty("filterExpr").getValue(), "boolean"));
        this.populateArgument(result, handle);
        this.populateAggregateOns(result, handle);
        return result;
    }

    public IBinding adaptBinding(ComputedColumnHandle handle, IModelAdapter.ExpressionLocation el) throws AdapterException {
        if (el.equals((Object)IModelAdapter.ExpressionLocation.TABLE)) {
            return this.adaptBinding(handle);
        }
        Binding binding = null;
        try {
            binding = new Binding(handle.getName());
            binding.setAggrFunction(handle.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType(handle.getAggregateFunction()));
            binding.setExpression(this.adaptExpression((Expression)handle.getExpressionProperty("expression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
            binding.setDataType(DataAdapterUtil.adaptModelDataType(handle.getDataType()));
            if (handle.getFilterExpression() != null) {
                binding.setFilter(this.adaptExpression((Expression)handle.getExpressionProperty("filterExpr").getValue(), IModelAdapter.ExpressionLocation.CUBE));
            }
            Iterator argItr = handle.argumentsIterator();
            while (argItr.hasNext()) {
                AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                binding.addArgument(aah.getName(), this.adaptExpression((Expression)aah.getExpressionProperty("value").getValue(), IModelAdapter.ExpressionLocation.CUBE));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
        try {
            binding.setTimeFunction(this.adaptTimeFunction(handle));
        }
        catch (BirtException ex) {
            throw new AdapterException(ex.getLocalizedMessage());
        }
        return binding;
    }

    public ITimeFunction adaptTimeFunction(ComputedColumnHandle handle) throws DataException, BirtException {
        if (handle.getCalculationType() == null || handle.getCalculationType().trim().length() == 0) {
            return null;
        }
        TimeFunction timeFunction = new TimeFunction();
        Object referenceDate = null;
        if ("today".equals(handle.getReferenceDateType())) {
            referenceDate = ScriptEvalUtil.evalExpr(new ScriptExpression("new java.util.Date()"), this.context.getDataEngineContext().getScriptContext(), "", 0);
        } else if ("fixedDate".equals(handle.getReferenceDateType())) {
            ScriptExpression sciptExpr = this.adaptExpression((Expression)handle.getReferenceDateValue().getValue());
            referenceDate = ScriptEvalUtil.evalExpr(sciptExpr, this.context.getDataEngineContext().getScriptContext(), "", 0);
        }
        timeFunction.setReferenceDate(new ReferenceDate(DataTypeUtil.toDate(referenceDate)));
        timeFunction.setTimeDimension(handle.getTimeDimension());
        timeFunction.setBaseTimePeriod(this.populateBaseTimePeriod(handle));
        timeFunction.setRelativeTimePeriod(this.populateRelativeTimePeriod(handle));
        return timeFunction;
    }

    private ITimePeriod populateBaseTimePeriod(ComputedColumnHandle periodHandle) throws DataException, BirtException {
        String calculateType = periodHandle.getCalculationType();
        TimePeriod baseTimePeriod = null;
        if ("CURRENT QUARTER".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.QUARTER, true);
        } else if ("PREVIOUS YEAR".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.YEAR, true);
        } else if ("PREVIOUS QUARTER".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.QUARTER, true);
        } else if ("PREVIOUS MONTH".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.MONTH, true);
        } else if ("CURRENT MONTH".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.MONTH, true);
        } else if ("TRAILING 30 DAYS".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(-30, TimePeriodType.DAY);
        } else if ("TRAILING 60 DAYS".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(-60, TimePeriodType.DAY);
        } else if ("TRAILING 90 DAYS".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(-90, TimePeriodType.DAY);
        } else if ("TRAILING 120 DAYS".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(-120, TimePeriodType.DAY);
        } else if ("TRAILING 12 MONTHS".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(-12, TimePeriodType.MONTH);
        } else if ("YEAR TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        } else if ("QUARTER TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.QUARTER);
        } else if ("MONTH TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        } else if ("CURRENT YEAR".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.YEAR, true);
        } else if ("WEEK TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.WEEK);
        } else if ("WEEK TO DATE LAST YEAR".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.WEEK);
        } else if ("MONTH TO DATE LAST YEAR".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        } else if ("QUARTER TO DATE LAST YEAR".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.QUARTER);
        } else if ("PREVIOUS WEEK TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.WEEK);
        } else if ("PREVIOUS MONTH TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        } else if ("PREVIOUS QUARTER TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.QUARTER);
        } else if ("PREVIOUS YEAR TO DATE".equals(calculateType)) {
            baseTimePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        } else if ("CURRENT PERIOD FROM N PERIODS AGO".equals(calculateType) || "PERIOD TO DATE FROM N PERIODS AGO".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String period1 = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"Period1".equals(argument.getName())) continue;
                period1 = argument.getValue().getStringExpression();
                break;
            }
            baseTimePeriod = "CURRENT PERIOD FROM N PERIODS AGO".equals(calculateType) ? new TimePeriod(0, DataAdapterUtil.toTimePeriodType(period1), true) : new TimePeriod(0, DataAdapterUtil.toTimePeriodType(period1));
        } else if ("TRAILING N MONTHS".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
            }
            baseTimePeriod = new TimePeriod(0 - this.evaluatePeriodsNForTrailingFunction(n), TimePeriodType.MONTH);
        } else if ("TRAILING N DAYS".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
            }
            baseTimePeriod = new TimePeriod(0 - this.evaluatePeriodsNForTrailingFunction(n), TimePeriodType.DAY);
        } else if ("TRAILING N PERIODS FROM N PERIODS AGO".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String period1 = null;
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if ("Period1".equals(argument.getName())) {
                    period1 = argument.getValue().getStringExpression();
                }
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
            }
            baseTimePeriod = new TimePeriod(0 - this.evaluatePeriodsNForTrailingFunction(n), DataAdapterUtil.toTimePeriodType(period1));
        } else if ("NEXT_N_PERIODS".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            String period1 = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if ("Period1".equals(argument.getName())) {
                    period1 = argument.getValue().getStringExpression();
                }
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
            }
            baseTimePeriod = new TimePeriod(this.evaluatePeriodsNForTrailingFunction(n), DataAdapterUtil.toTimePeriodType(period1));
        }
        return baseTimePeriod;
    }

    private ITimePeriod populateRelativeTimePeriod(ComputedColumnHandle periodHandle) throws DataException, BirtException {
        String calculateType = periodHandle.getCalculationType();
        TimePeriod relativeTimePeriod = null;
        if ("WEEK TO DATE LAST YEAR".equals(calculateType) || "MONTH TO DATE LAST YEAR".equals(calculateType) || "QUARTER TO DATE LAST YEAR".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
                break;
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), TimePeriodType.YEAR);
        } else if ("PREVIOUS WEEK TO DATE".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
                break;
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), TimePeriodType.WEEK);
        } else if ("PREVIOUS MONTH TO DATE".equals(calculateType) || "PREVIOUS MONTH".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
                break;
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), TimePeriodType.MONTH);
        } else if ("PREVIOUS QUARTER TO DATE".equals(calculateType) || "PREVIOUS QUARTER".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
                break;
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), TimePeriodType.QUARTER);
        } else if ("PREVIOUS YEAR TO DATE".equals(calculateType) || "PREVIOUS YEAR".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if (!"N for Period1".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
                break;
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), TimePeriodType.YEAR);
        } else if ("CURRENT PERIOD FROM N PERIODS AGO".equals(calculateType) || "PERIOD TO DATE FROM N PERIODS AGO".equals(calculateType) || "TRAILING N PERIODS FROM N PERIODS AGO".equals(calculateType)) {
            Iterator iter = periodHandle.calculationArgumentsIterator();
            String period2 = null;
            String n = null;
            while (iter.hasNext()) {
                CalculationArgumentHandle argument = (CalculationArgumentHandle)iter.next();
                if ("Period2".equals(argument.getName())) {
                    period2 = argument.getValue().getStringExpression();
                }
                if (!"N for Period2".equals(argument.getName())) continue;
                n = argument.getValue().getStringExpression();
            }
            relativeTimePeriod = new TimePeriod(0 - this.evaluatePeriodsN(n), DataAdapterUtil.toTimePeriodType(period2));
        }
        return relativeTimePeriod;
    }

    private int evaluatePeriodsN(String n) throws DataException, BirtException {
        int num = 0;
        if (n == null || n.trim().equals("")) {
            n = "0";
        }
        try {
            num = Integer.valueOf(n);
        }
        catch (Exception exception) {
            num = (Integer)ScriptEvalUtil.evalExpr(new ScriptExpression(n), this.context.getDataEngineContext().getScriptContext(), "", 0);
        }
        return num;
    }

    private int evaluatePeriodsNForTrailingFunction(String n) throws DataException, BirtException {
        int num = 0;
        if (n == null || n.trim().equals("")) {
            n = "1";
        }
        try {
            num = Integer.valueOf(n);
        }
        catch (Exception exception) {
            num = (Integer)ScriptEvalUtil.evalExpr(new ScriptExpression(n), this.context.getDataEngineContext().getScriptContext(), "", 0);
        }
        return num;
    }

    private void populateAggregateOns(IBinding result, ComputedColumnHandle handle) throws AdapterException {
        List aggrOns = handle.getAggregateOnList();
        if (aggrOns == null) {
            return;
        }
        int i = 0;
        while (i < aggrOns.size()) {
            try {
                result.addAggregateOn(aggrOns.get(i).toString());
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
            ++i;
        }
    }

    private void populateArgument(IBinding binding, ComputedColumnHandle modelCmptdColumn) throws AdapterException {
        Iterator it = modelCmptdColumn.argumentsIterator();
        while (it != null && it.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)it.next();
            try {
                Expression expr = (Expression)arg.getExpressionProperty("value").getValue();
                binding.addArgument(this.adaptExpression(expr));
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
        }
    }

    public ConditionalExpression adaptConditionalExpression(Expression mainExpr, String operator, Expression operand1, Expression operand2) {
        return new ConditionAdapter((IScriptExpression)this.adaptExpression(mainExpr), operator, (IBaseExpression)this.adaptExpression(operand1), (IBaseExpression)this.adaptExpression(operand2));
    }

    public ScriptExpression adaptExpression(Expression expr) {
        return this.adaptExpression(expr, IModelAdapter.ExpressionLocation.TABLE);
    }

    public ScriptExpression adaptExpression(String jsExpr, String dataType) {
        if (jsExpr == null) {
            return null;
        }
        return new ExpressionAdapter(jsExpr, dataType);
    }

    public ScriptExpression adaptJSExpression(String jsExpr, String dataType) {
        if (jsExpr == null) {
            return null;
        }
        return new ExpressionAdapter(jsExpr, dataType);
    }

    public ScriptExpression adaptExpression(Expression expr, IModelAdapter.ExpressionLocation el) {
        if (expr == null) {
            return null;
        }
        ScriptExpression jsExpr = null;
        if ("constant".equals(expr.getType())) {
            jsExpr = new ScriptExpression(JavascriptEvalUtil.transformToJsExpression(expr.getStringExpression()));
            jsExpr.setConstant(true);
            jsExpr.setConstantValue(expr.getExpression());
            return jsExpr;
        }
        if (expr.getStringExpression() == null) {
            return null;
        }
        jsExpr = new ExpressionAdapter(expr, el);
        return jsExpr;
    }
}

