/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class CellExecutor
extends ContainerExecutor {
    private int nextItem = 0;

    protected CellExecutor(ExecutorManager manager) {
        super(manager, 14);
    }

    protected IContent doCreateContent() {
        return this.report.createCellContent();
    }

    protected void doExecute() throws Exception {
        this.executeQuery();
    }

    public void close() {
        this.nextItem = 0;
        this.closeQuery();
        super.close();
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        CellDesign cellDesign = (CellDesign)this.design;
        if (this.nextItem < cellDesign.getContentCount()) {
            ReportItemDesign design = cellDesign.getContent(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, design, this.nextOffset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        CellDesign cellDesign = (CellDesign)this.design;
        int itemCount = cellDesign.getContentCount();
        long designId = id.getComponentID();
        int i = 0;
        while (i < itemCount) {
            ReportItemDesign childDesign = cellDesign.getContent(i);
            if (designId == childDesign.getID()) {
                this.nextItem = i;
                return;
            }
            ++i;
        }
        this.nextItem = itemCount;
    }
}

