/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IGridEventHandler;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Grid;
import org.eclipse.birt.report.engine.script.internal.instance.GridInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.GridHandle;

public class GridScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(GridHandle gridHandle, ExecutionContext context) {
        try {
            Grid grid = new Grid(gridHandle);
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridHandle, context);
            if (eh != null) {
                eh.onPrepare(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ITableContent content, ExecutionContext context) {
        ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
        if (!GridScriptExecutor.needOnCreate(gridDesign)) {
            return;
        }
        try {
            GridInstance grid = new GridInstance(content, context, RunningState.CREATE);
            if (GridScriptExecutor.handleScript(grid, gridDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onCreate(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e, gridDesign.getHandle());
        }
    }

    public static void handleOnRender(ITableContent content, ExecutionContext context) {
        ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
        if (!GridScriptExecutor.needOnRender(gridDesign)) {
            return;
        }
        try {
            GridInstance grid = new GridInstance(content, context, RunningState.RENDER);
            if (GridScriptExecutor.handleScript(grid, gridDesign.getOnRender(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onRender(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e, gridDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(ITableContent content, ExecutionContext context) {
        ReportItemDesign gridDesign = (ReportItemDesign)content.getGenerateBy();
        if (!GridScriptExecutor.needOnPageBreak(gridDesign, context)) {
            return;
        }
        try {
            GridInstance grid = new GridInstance(content, context, RunningState.PAGEBREAK);
            if (GridScriptExecutor.handleScript(grid, gridDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IGridEventHandler eh = GridScriptExecutor.getEventHandler(gridDesign, context);
            if (eh != null) {
                eh.onPageBreak(grid, context.getReportContext());
            }
        }
        catch (Exception e) {
            GridScriptExecutor.addException(context, e, gridDesign.getHandle());
        }
    }

    private static IGridEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IGridEventHandler)GridScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            GridScriptExecutor.addClassCastException(context, e, design.getHandle(), IGridEventHandler.class);
        }
        catch (EngineException e) {
            GridScriptExecutor.addException(context, e, design.getHandle());
        }
        return null;
    }

    private static IGridEventHandler getEventHandler(GridHandle handle, ExecutionContext context) {
        try {
            return (IGridEventHandler)GridScriptExecutor.getInstance(handle, context);
        }
        catch (ClassCastException e) {
            GridScriptExecutor.addClassCastException(context, e, handle, IGridEventHandler.class);
        }
        catch (EngineException e) {
            GridScriptExecutor.addException(context, e, handle);
        }
        return null;
    }
}

