/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.FullEventFilter;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutCompoundRecord
extends FilterEventsCompoundRecord {
    public LayoutCompoundRecord(String text, boolean isOutermostSilentTrans) {
        super(text, isOutermostSilentTrans);
    }

    protected void setFilterAll(boolean filterAll) {
        if (this.isOutermostFilterTrans && filterAll) {
            this.options = new TransactionOption();
            this.options.setEventfilter(new FullEventFilter());
            this.options.setSendTime(2);
        }
    }

    @Override
    protected void performPostTasks(Stack<CompoundRecord> transStack) {
        if (!this.isOutermostFilterTrans) {
            return;
        }
        List<RecordTask> layoutTasks = ModelUtil.filterLayoutTasks(this.getPostTasks());
        this.doTasks(transStack, layoutTasks);
        super.performPostTasks(transStack);
    }

    @Override
    public void undo() {
        int i = this.getRecords().size() - 1;
        while (i >= 0) {
            ActivityRecord record = this.getRecords().get(i);
            assert (record.getState() == 1 || record.getState() == 3);
            assert (record.getClass() != CompoundRecord.class);
            record.undo();
            record.setState(2);
            --i;
        }
    }

    @Override
    public void redo() {
        int i = 0;
        while (i < this.getRecords().size()) {
            ActivityRecord record = this.getRecords().get(i);
            assert (record.getState() == 2);
            assert (record.getClass() != CompoundRecord.class);
            record.redo();
            record.setState(3);
            ++i;
        }
    }

    @Override
    public void rollback() {
        int i = this.getRecords().size() - 1;
        while (i >= 0) {
            ActivityRecord record = this.getRecords().get(i);
            assert (record.getClass() != CompoundRecord.class);
            if (!record.isPersistent()) {
                record.rollback();
            }
            --i;
        }
    }
}

