/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpMulticastConnector
extends UDPConnector {
    public static final Logger LOGGER = LoggerFactory.getLogger(UdpMulticastConnector.class);
    private NetworkInterface outgoingInterface;
    private InetAddress outgoingAddress;
    private List<Join> groups = new ArrayList<Join>();
    private boolean loopbackDisable;

    @Deprecated
    public UdpMulticastConnector(InetAddress intfAddress, InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        this(localAddress, intfAddress, null, UdpMulticastConnector.toList(multicastGroups));
    }

    @Deprecated
    public UdpMulticastConnector(InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        this(localAddress, null, null, UdpMulticastConnector.toList(multicastGroups));
    }

    private UdpMulticastConnector(InetSocketAddress localSocketAddress, InetAddress outgoingAddress, NetworkInterface outgoingInterface, List<Join> groups) {
        super(localSocketAddress);
        this.setReuseAddress(true);
        this.outgoingInterface = outgoingInterface;
        this.outgoingAddress = outgoingAddress;
        this.groups.addAll(groups);
        InetAddress localAddress = localSocketAddress.getAddress();
        boolean noGroups = this.groups.isEmpty();
        if (NetworkInterfacesUtil.isBroadcastAddress(localAddress)) {
            this.multicast = noGroups;
        } else {
            if (noGroups) {
                if (localAddress.isMulticastAddress()) {
                    this.groups.add(new Join(localAddress));
                    noGroups = false;
                } else {
                    throw new IllegalArgumentException("missing multicast address to join!");
                }
            }
            boolean bl = this.multicast = this.groups.size() == 1;
            if (this.multicast) {
                this.effectiveAddr = new InetSocketAddress(this.groups.get(0).multicastGroup, localSocketAddress != null ? localSocketAddress.getPort() : 0);
            }
        }
    }

    public void setLoopbackMode(boolean disable) {
        this.loopbackDisable = disable;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        InetAddress effectiveInterface = this.localAddr.getAddress();
        MulticastSocket socket = new MulticastSocket(null);
        socket.setLoopbackMode(this.loopbackDisable);
        try {
            socket.bind(this.localAddr);
            LOGGER.info("socket {}, loopback mode {}", (Object)StringUtil.toString((InetSocketAddress)socket.getLocalSocketAddress()), (Object)socket.getLoopbackMode());
        }
        catch (BindException ex) {
            socket.close();
            LOGGER.error("can't bind to {}", (Object)StringUtil.toString(this.localAddr));
            throw ex;
        }
        catch (SocketException ex) {
            socket.close();
            LOGGER.error("can't bind to {}", (Object)StringUtil.toString(this.localAddr));
            throw ex;
        }
        if (this.outgoingAddress != null && !this.outgoingAddress.isAnyLocalAddress()) {
            try {
                socket.setInterface(this.outgoingAddress);
                effectiveInterface = this.outgoingAddress;
                LOGGER.info("interface {}", (Object)StringUtil.toString(this.outgoingAddress));
            }
            catch (SocketException ex) {
                LOGGER.error("error: multicast set interface", (Throwable)ex);
            }
        } else if (this.outgoingInterface != null) {
            try {
                socket.setNetworkInterface(this.outgoingInterface);
                LOGGER.info("interface {}", (Object)this.outgoingInterface.getDisplayName());
            }
            catch (SocketException ex) {
                LOGGER.error("error: multicast set interface", (Throwable)ex);
            }
        }
        for (Join join : this.groups) {
            try {
                boolean supportJoinWithInterface = true;
                if (join.networkInterface != null) {
                    try {
                        socket.joinGroup(new InetSocketAddress(join.multicastGroup, 0), join.networkInterface);
                        LOGGER.info("joined group {} with {}", (Object)StringUtil.toString(join.multicastGroup), (Object)join.networkInterface.getDisplayName());
                    }
                    catch (UnsupportedOperationException ex) {
                        supportJoinWithInterface = false;
                    }
                }
                if (supportJoinWithInterface && join.networkInterface != null) continue;
                socket.joinGroup(join.multicastGroup);
                LOGGER.info("joined group {}", (Object)StringUtil.toString(join.multicastGroup));
            }
            catch (SocketException ex) {
                socket.close();
                if (join.multicastGroup instanceof Inet4Address) {
                    if (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv4() || effectiveInterface instanceof Inet6Address) {
                        throw new SocketException("IPv6 only interface doesn't support IPv4 multicast!");
                    }
                } else if (join.multicastGroup instanceof Inet6Address && (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv6() || effectiveInterface instanceof Inet4Address)) {
                    throw new SocketException("IPv4 only interface doesn't support IPv6 multicast!");
                }
                throw ex;
            }
        }
        this.init(socket);
        if (this.multicast && this.groups.size() == 1) {
            this.effectiveAddr = new InetSocketAddress(this.groups.get(0).multicastGroup, socket.getLocalPort());
        }
    }

    private static List<Join> toList(InetAddress ... multicastGroups) {
        ArrayList<Join> groups = new ArrayList<Join>();
        if (multicastGroups != null) {
            for (InetAddress group : multicastGroups) {
                groups.add(new Join(group));
            }
        }
        return groups;
    }

    public static class Builder {
        private InetSocketAddress localSocketAddress;
        private InetAddress outgoingAddress;
        private NetworkInterface outgoingInterface;
        private List<Join> groups = new ArrayList<Join>();

        public InetSocketAddress getLocalAddress() {
            return this.localSocketAddress;
        }

        public Builder setLocalPort(int port) {
            this.localSocketAddress = new InetSocketAddress(port);
            return this;
        }

        public Builder setLocalAddress(InetAddress localAddress, int port) {
            if (localAddress == null) {
                throw new NullPointerException("local address must not be null!");
            }
            this.localSocketAddress = new InetSocketAddress(localAddress, port);
            return this;
        }

        public Builder setLocalAddress(InetSocketAddress localSocketAddress) {
            if (localSocketAddress == null) {
                throw new NullPointerException("local socket address must not be null!");
            }
            this.localSocketAddress = localSocketAddress;
            return this;
        }

        public Builder setOutgoingMulticastInterface(InetAddress outgoingAddress) {
            this.outgoingAddress = outgoingAddress;
            this.outgoingInterface = null;
            return this;
        }

        public Builder setOutgoingMulticastInterface(NetworkInterface outgoingInterface) {
            this.outgoingAddress = null;
            this.outgoingInterface = outgoingInterface;
            return this;
        }

        public Builder addMulticastGroup(InetAddress multicastGroup) {
            this.groups.add(new Join(multicastGroup));
            return this;
        }

        public Builder addMulticastGroup(InetAddress multicastGroup, NetworkInterface networkInterface) {
            this.groups.add(new Join(multicastGroup, networkInterface));
            return this;
        }

        public UdpMulticastConnector build() {
            return new UdpMulticastConnector(this.localSocketAddress, this.outgoingAddress, this.outgoingInterface, this.groups);
        }
    }

    private static class Join {
        private final InetAddress multicastGroup;
        private final NetworkInterface networkInterface;

        private Join(InetAddress multicastGroup) {
            this.multicastGroup = multicastGroup;
            this.networkInterface = null;
        }

        private Join(InetAddress multicastGroup, NetworkInterface networkInterface) {
            this.multicastGroup = multicastGroup;
            this.networkInterface = networkInterface;
        }
    }
}

