/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Set;

public enum SignatureAlgorithm {
    DEFAULT("JVM-Default-Signature-Algorithm", new String[0]),
    NONEwithRSA("NONEwithRSA", new String[0]),
    MD2withRSA("MD2withRSA", new String[0]),
    MD5withRSA("MD5withRSA", new String[0]),
    SHA1withRSA("SHA1withRSA", new String[0]),
    SHA224withRSA("SHA224withRSA", new String[0]),
    SHA256withRSA("SHA256withRSA", new String[0]),
    SHA384withRSA("SHA384withRSA", new String[0]),
    SHA512withRSA("SHA512withRSA", new String[0]),
    SHA1withDSA("SHA1withDSA", new String[0]),
    SHA224withDSA("SHA224withDSA", new String[0]),
    SHA256withDSA("SHA256withDSA", new String[0]),
    NONEwithECDSA("NONEwithECDSA", new String[0]),
    SHA1withECDSA("SHA1withECDSA", new String[0]),
    SHA224withECDSA("SHA224withECDSA", new String[0]),
    SHA256withECDSA("SHA256withECDSA", new String[0]),
    SHA384withECDSA("SHA384withECDSA", new String[0]),
    SHA512withECDSA("SHA512withECDSA", new String[0]);

    private final String standardName;
    private final Set<String> aliases;

    private SignatureAlgorithm(String standardName, String ... alias) {
        this.standardName = standardName;
        this.aliases = ImmutableSet.copyOf((Object[])alias);
    }

    public String standardName() {
        return this.standardName;
    }

    public static SignatureAlgorithm fromStandardName(String signatureAlgorithmName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)signatureAlgorithmName) ? 1 : 0) != 0);
        Optional ret = Iterables.tryFind(EnumSet.allOf(SignatureAlgorithm.class), d -> signatureAlgorithmName.equals(d.standardName) || d.aliases.contains(signatureAlgorithmName));
        if (!ret.isPresent()) {
            throw new IllegalArgumentException("Unknow signature algorithm '" + signatureAlgorithmName + "'");
        }
        return (SignatureAlgorithm)((Object)ret.get());
    }
}

