/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.cbi.common.util.Record;
import org.eclipse.cbi.common.util.RecordDefinition;

class ByteBufferRecord
implements Record {
    private final ByteBuffer buffer;
    private final RecordDefinition recordDefinition;

    public ByteBufferRecord(RecordDefinition recordDefinition, ByteBuffer buffer) throws IOException {
        this.recordDefinition = (RecordDefinition)Preconditions.checkNotNull((Object)recordDefinition);
        this.buffer = (ByteBuffer)Preconditions.checkNotNull((Object)buffer);
    }

    @Override
    public int uint16Value(RecordDefinition.Field field) {
        int offset = this.offset((RecordDefinition.Field)Preconditions.checkNotNull((Object)field));
        return this.buffer.order(field.byteOrder()).getShort(offset) & 0xFFFF;
    }

    @Override
    public UnsignedInteger uint32Value(RecordDefinition.Field field) {
        int offset = this.offset((RecordDefinition.Field)Preconditions.checkNotNull((Object)field));
        return UnsignedInteger.fromIntBits((int)this.buffer.order(field.byteOrder()).getInt(offset));
    }

    @Override
    public UnsignedLong uint64Value(RecordDefinition.Field field) {
        int offset = this.offset((RecordDefinition.Field)Preconditions.checkNotNull((Object)field));
        return UnsignedLong.fromLongBits((long)this.buffer.order(field.byteOrder()).getLong(offset));
    }

    @Override
    public String stringValue(RecordDefinition.Field field, Charset charset) {
        int offset = this.offset((RecordDefinition.Field)Preconditions.checkNotNull((Object)field));
        int size = Ints.checkedCast((long)this.size((RecordDefinition.Field)Preconditions.checkNotNull((Object)field)));
        byte[] dst = new byte[size];
        this.buffer.position(offset);
        this.buffer.order(field.byteOrder()).get(dst);
        return new String(dst, charset);
    }

    @Override
    public long size() {
        long size;
        if (this.recordDefinition.fields().isEmpty()) {
            size = 0L;
        } else {
            RecordDefinition.Field lastField = this.recordDefinition.fields().get(this.recordDefinition.fields().size() - 1);
            size = (long)this.offset(lastField) + this.size(lastField);
            if (size < 0L) {
                throw new ArithmeticException("long overflow");
            }
        }
        return size;
    }

    private int offset(RecordDefinition.Field field) {
        Preconditions.checkNotNull((Object)field);
        long offset = 0L;
        for (RecordDefinition.Field f : this.recordDefinition.fields()) {
            if (field == f) break;
            if ((offset += this.size(f)) >= 0L) continue;
            throw new ArithmeticException("long overflow");
        }
        return Ints.checkedCast((long)offset);
    }

    private long size(RecordDefinition.Field f) {
        long r;
        Preconditions.checkNotNull((Object)f);
        if (f.type() != RecordDefinition.Field.Type.VARIABLE) {
            r = f.type().size();
        } else {
            RecordDefinition.Field lenghtField = this.recordDefinition.fieldDefiningSizeOf(f);
            switch (lenghtField.type()) {
                case UINT_16: {
                    r = this.uint16Value(lenghtField);
                    break;
                }
                case UINT_32: {
                    r = this.uint32Value(lenghtField).longValue();
                    break;
                }
                case UINT_64: {
                    long r2 = this.uint64Value(lenghtField).longValue();
                    if (r2 < 0L) {
                        throw new ArithmeticException("Can not handle uint64 size larger than Long.MAX_VALUE");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported field type for length");
                }
            }
        }
        return r;
    }
}

