/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.collect.ImmutableList;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

final class MorePosixFilePermissions {
    private static final ImmutableList<PosixFilePermission> POSIX_PERMISSIONS = ImmutableList.of((Object)((Object)PosixFilePermission.OTHERS_EXECUTE), (Object)((Object)PosixFilePermission.OTHERS_WRITE), (Object)((Object)PosixFilePermission.OTHERS_READ), (Object)((Object)PosixFilePermission.GROUP_EXECUTE), (Object)((Object)PosixFilePermission.GROUP_WRITE), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.OWNER_EXECUTE), (Object)((Object)PosixFilePermission.OWNER_WRITE), (Object)((Object)PosixFilePermission.OWNER_READ));
    private static final int MAX_MODE = (1 << POSIX_PERMISSIONS.size()) - 1;

    private MorePosixFilePermissions() {
        throw new AssertionError();
    }

    public static long toFileMode(Set<PosixFilePermission> permissions) {
        int filemode = 0;
        for (int i = 0; i < POSIX_PERMISSIONS.size(); ++i) {
            if (!permissions.contains(POSIX_PERMISSIONS.get(i))) continue;
            filemode |= 1 << i;
        }
        return filemode;
    }

    public static Set<PosixFilePermission> fromFileMode(long filemode) {
        if ((filemode & (long)MAX_MODE) != filemode) {
            throw new IllegalStateException("Invalid file mode '" + Integer.toOctalString((int)filemode) + "'. File mode must be between 0 and " + MAX_MODE + " (" + Integer.toOctalString(MAX_MODE) + " in octal)");
        }
        EnumSet<PosixFilePermission> ret = EnumSet.noneOf(PosixFilePermission.class);
        for (int i = 0; i < POSIX_PERMISSIONS.size(); ++i) {
            if ((filemode & (long)(1 << i)) == 0L) continue;
            ret.add((PosixFilePermission)((Object)POSIX_PERMISSIONS.get(i)));
        }
        return ret;
    }
}

