/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class Paths {
    public static void deleteQuietly(Path path) {
        try {
            Paths.doDelete(path, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delete(Path path) throws IOException {
        Paths.doDelete(path, false);
    }

    private static void doDelete(Path path, boolean quiet) throws IOException {
        Objects.requireNonNull(path);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, new DeletionVisitor(quiet));
        } else if (quiet) {
            Files.deleteIfExists(path);
        } else {
            Files.delete(path);
        }
    }

    public static Path getParent(Path path) {
        Objects.requireNonNull(path);
        Path normalizedParent = path.normalize().getParent();
        Path parent = normalizedParent == null ? path.getFileSystem().getRootDirectories().iterator().next() : normalizedParent;
        return parent;
    }

    private static final class DeletionVisitor
    extends SimpleFileVisitor<Path> {
        private final boolean quiet;

        public DeletionVisitor(boolean quiet) {
            this.quiet = quiet;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Objects.requireNonNull(dir);
            if (exc == null) {
                try {
                    if (this.quiet) {
                        Files.deleteIfExists(dir);
                    } else {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
                catch (IOException e) {
                    if (this.quiet) {
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            }
            if (this.quiet) {
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Objects.requireNonNull(file);
            Objects.requireNonNull(attrs);
            if (this.quiet) {
                Files.deleteIfExists(file);
            } else {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            Objects.requireNonNull(file);
            if (this.quiet) {
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }
    }
}

