/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.common.util.AutoValue_RecordDefinition;
import org.eclipse.cbi.common.util.Record;

@AutoValue
abstract class RecordDefinition {
    RecordDefinition() {
    }

    public abstract String name();

    public abstract long signature();

    public abstract Optional<Field> signatureField();

    public abstract List<Field> fields();

    protected abstract Map<Field, Field> sizeDefinitionFields();

    public abstract Class<? extends Record> recordClass();

    public Field fieldDefiningSizeOf(Field field) {
        Preconditions.checkArgument((field.type() == Field.Type.VARIABLE ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.fields().contains(field));
        Field sizeDefField = this.sizeDefinitionFields().get(field);
        if (sizeDefField == null) {
            throw new NullPointerException();
        }
        return sizeDefField;
    }

    public int size() {
        int size = 0;
        for (Field f : this.fields()) {
            if (f.type() != Field.Type.VARIABLE) {
                size += f.type().size();
                continue;
            }
            throw new UnsupportedOperationException("Record definition size is not fixed");
        }
        return size;
    }

    public static Builder builder() {
        return new AutoValue_RecordDefinition.Builder().sizeDefinitionFields((Map<Field, Field>)ImmutableMap.of()).signature(-1L).signatureField((Optional<Field>)Optional.absent());
    }

    public static Field createLEField(Field.Type size, String name) {
        return new BasicFieldImpl(size, name, ByteOrder.LITTLE_ENDIAN);
    }

    private static class BasicFieldImpl
    implements Field {
        private final Field.Type size;
        private final String specname;
        private final ByteOrder endianness;

        BasicFieldImpl(Field.Type size, String specname, ByteOrder endianness) {
            this.endianness = endianness;
            this.size = (Field.Type)((Object)Preconditions.checkNotNull((Object)((Object)size)));
            this.specname = (String)Preconditions.checkNotNull((Object)specname);
        }

        @Override
        public Field.Type type() {
            return this.size;
        }

        @Override
        public String name() {
            return this.specname;
        }

        @Override
        public ByteOrder byteOrder() {
            return this.endianness;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.specname).add("size", (Object)this.type()).toString();
        }
    }

    public static interface Field {
        public static final int UINT16_MAX_VALUE = 65535;

        public String name();

        public ByteOrder byteOrder();

        public Type type();

        public static enum Type {
            UINT_16(2),
            UINT_32(4),
            UINT_64(8),
            VARIABLE(-1);

            private final int length;

            private Type(int length) {
                this.length = length;
            }

            public int size() {
                return this.length;
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder fields(List<Field> var1);

        public abstract Builder signature(long var1);

        public abstract Builder signatureField(Optional<Field> var1);

        public abstract Builder sizeDefinitionFields(Map<Field, Field> var1);

        public abstract Builder recordClass(Class<? extends Record> var1);

        abstract RecordDefinition autobuild();

        public RecordDefinition build() {
            RecordDefinition ret = this.autobuild();
            for (Field field : ret.fields()) {
                if (field.type() != Field.Type.VARIABLE) continue;
                Preconditions.checkArgument((ret.sizeDefinitionFields().get(field) != null ? 1 : 0) != 0);
            }
            for (Map.Entry entry : ret.sizeDefinitionFields().entrySet()) {
                Preconditions.checkArgument((boolean)ret.fields().contains(entry.getKey()));
                Preconditions.checkArgument((boolean)ret.fields().contains(entry.getValue()));
                Preconditions.checkArgument((((Field)entry.getKey()).type() == Field.Type.VARIABLE ? 1 : 0) != 0);
                Preconditions.checkArgument((((Field)entry.getValue()).type() != Field.Type.VARIABLE ? 1 : 0) != 0);
                Preconditions.checkArgument((ret.fields().indexOf(entry.getValue()) < ret.fields().indexOf(entry.getKey()) ? 1 : 0) != 0);
                if (ret.signatureField().isPresent()) continue;
                Preconditions.checkArgument((boolean)ret.fields().contains(ret.signatureField().get()));
            }
            return ret;
        }
    }
}

