/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.eclipse.cbi.common.util.ByteBufferRecord;
import org.eclipse.cbi.common.util.MorePosixFilePermissions;
import org.eclipse.cbi.common.util.Record;
import org.eclipse.cbi.common.util.RecordDefinition;
import org.eclipse.cbi.common.util.SeekableByteChannelRecordReader;

abstract class ZipPosixPermissionFixer {
    private final ZipReader zipReader;

    public ZipPosixPermissionFixer(ZipReader zipReader) {
        this.zipReader = zipReader;
    }

    public void fixEntries() throws IOException {
        long nextDirectoryHeaderPosition;
        long firstCentralDireactoryHeader = this.firstCentralDirectoryHeaderPosition();
        Optional<CentralDirectoryHeader> directoryHeader = this.zipReader.readCentralDirectoryHeader(firstCentralDireactoryHeader);
        if (!directoryHeader.isPresent()) {
            if (!this.zipReader.readLocalFileHeader(0L).isPresent()) {
                throw new ZipException("Not a zip archive");
            }
            throw new ZipException("Corrupted archive");
        }
        do {
            if (((CentralDirectoryHeader)directoryHeader.get()).platform() != CentralDirectoryHeader.Platform.UNIX) continue;
            this.fixEntry(((CentralDirectoryHeader)directoryHeader.get()).filename(), ((CentralDirectoryHeader)directoryHeader.get()).posixPermissions());
        } while ((directoryHeader = this.zipReader.readCentralDirectoryHeader(nextDirectoryHeaderPosition = this.zipReader.position((Record)directoryHeader.get()) + ((CentralDirectoryHeader)directoryHeader.get()).size())).isPresent());
    }

    protected abstract void fixEntry(String var1, Set<PosixFilePermission> var2) throws IOException;

    private long firstCentralDirectoryHeaderPosition() throws IOException {
        EndOfCentralDirectory eocdrp = this.findEndOfCentralDirectory();
        if (this.zipReader.position(eocdrp) > (long)Zip64EndOfCentralDirectoryLocator.DEFINITION.size()) {
            return this.firstDirectoryHeaderPositionZ64(eocdrp);
        }
        return eocdrp.offsetOfStartOfCentralDirectoryWithRespectToTheStartDiskNumber().longValue();
    }

    private long firstDirectoryHeaderPositionZ64(EndOfCentralDirectory eocdrp) throws IOException, ZipException {
        long z64eocdrp = this.zipReader.position(eocdrp) - (long)Zip64EndOfCentralDirectoryLocator.DEFINITION.size();
        Optional<Zip64EndOfCentralDirectoryLocator> z64eocdl = this.zipReader.readZip64EndOfCentralDirectoryLocator(z64eocdrp);
        if (z64eocdl.isPresent()) {
            Optional<Zip64EndOfCentralDirectory> zip64eocd = this.zipReader.readZip64EndOfCentralDirectory(((Zip64EndOfCentralDirectoryLocator)z64eocdl.get()).relativeOffsetOfTheZip64EndOfCentralDirectoryRecord().longValue());
            if (!zip64eocd.isPresent()) {
                throw new ZipException("Can't find Zip64 end of central directory");
            }
            return ((Zip64EndOfCentralDirectory)zip64eocd.get()).offsetOfStartOfCentralDirectoryWithRespectToTheStartingDiskNumber();
        }
        return eocdrp.offsetOfStartOfCentralDirectoryWithRespectToTheStartDiskNumber().longValue();
    }

    private EndOfCentralDirectory findEndOfCentralDirectory() throws IOException {
        long startPosition;
        long endPosition = Math.max(0L, this.zipReader.zipSize() - (long)EndOfCentralDirectory.MAX_SIZE);
        for (long positionToCheck = startPosition = this.zipReader.zipSize() - (long)EndOfCentralDirectory.MIN_SIZE; positionToCheck >= endPosition; --positionToCheck) {
            Optional<EndOfCentralDirectory> endOfCentralDirectory = this.zipReader.readEndOfCentralDirectory(positionToCheck);
            if (!endOfCentralDirectory.isPresent()) continue;
            return (EndOfCentralDirectory)endOfCentralDirectory.get();
        }
        throw new ZipException("End of central directory record not found");
    }

    static class LocalFileHeader
    extends Record.Fowarding {
        private static final long SIGNATURE = 67324752L;
        public static final RecordDefinition.Field LFHS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "local file header signature");
        public static final RecordDefinition.Field VNTE = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "version needed to extract");
        public static final RecordDefinition DEFINITION = RecordDefinition.builder().name("Local file header").fields((List<RecordDefinition.Field>)ImmutableList.of((Object)LFHS, (Object)VNTE)).recordClass(LocalFileHeader.class).signature(67324752L).signatureField((Optional<RecordDefinition.Field>)Optional.of((Object)LFHS)).build();

        public LocalFileHeader(Record delegate) {
            super(delegate);
        }
    }

    static class Zip64EndOfCentralDirectory
    extends Record.Fowarding {
        public static final long SIGNATURE = 101075792L;
        public static final RecordDefinition.Field Z64EOCDS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "zip64 end of central dir signature");
        public static final RecordDefinition.Field SOZ64EOCDR = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "size of zip64 end of central directory record");
        public static final RecordDefinition.Field VMB = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "version made by");
        public static final RecordDefinition.Field VNTE = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "version needed to extract");
        public static final RecordDefinition.Field NOTD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "number of this disk");
        public static final RecordDefinition.Field NOTDWTSOTCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "number of the disk with the start of the central directory");
        public static final RecordDefinition.Field TNOEITCDOTD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "total number of entries in the central directory on this disk");
        public static final RecordDefinition.Field TNOEITCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "total number of entries in the central directory");
        public static final RecordDefinition.Field SOTCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "size of the central directory");
        public static final RecordDefinition.Field OOSOCDWRTTSDN = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "offset of start of central directory with respect to the starting disk number");
        public static final RecordDefinition DEFINITION = RecordDefinition.builder().name("Zip64 End of Central Directory").fields((List<RecordDefinition.Field>)ImmutableList.of((Object)Z64EOCDS, (Object)SOZ64EOCDR, (Object)VMB, (Object)VNTE, (Object)NOTD, (Object)NOTDWTSOTCD, (Object)TNOEITCDOTD, (Object)TNOEITCD, (Object)SOTCD, (Object)OOSOCDWRTTSDN)).recordClass(Zip64EndOfCentralDirectory.class).signature(101075792L).signatureField((Optional<RecordDefinition.Field>)Optional.of((Object)Z64EOCDS)).build();

        public Zip64EndOfCentralDirectory(Record delegate) {
            super(delegate);
        }

        public long offsetOfStartOfCentralDirectoryWithRespectToTheStartingDiskNumber() {
            UnsignedLong v = this.delegate().uint64Value(OOSOCDWRTTSDN);
            if (v.compareTo(UnsignedLong.valueOf((long)Long.MAX_VALUE)) > 0) {
                throw new IllegalStateException("Can not handle uint64 offset larger than Long.MAX_VALUE");
            }
            return v.longValue();
        }
    }

    static final class Zip64EndOfCentralDirectoryLocator
    extends Record.Fowarding {
        public static final long SIGNATURE = 117853008L;
        public static final RecordDefinition.Field Z64EOCDLS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "zip64 end of central dir locator signature");
        public static final RecordDefinition.Field NODWSZ64EOCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "number of the disk with the start of the zip64 end of central directory");
        public static final RecordDefinition.Field ROZ64EOCDR = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_64, "relative offset of the zip64 end of central directory record");
        public static final RecordDefinition.Field TNOD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "total number of disks");
        public static final RecordDefinition DEFINITION = RecordDefinition.builder().name("Zip64 End of Central Directory Locator").fields((List<RecordDefinition.Field>)ImmutableList.of((Object)Z64EOCDLS, (Object)NODWSZ64EOCD, (Object)ROZ64EOCDR, (Object)TNOD)).recordClass(Zip64EndOfCentralDirectoryLocator.class).signature(117853008L).signatureField((Optional<RecordDefinition.Field>)Optional.of((Object)Z64EOCDLS)).build();

        public Zip64EndOfCentralDirectoryLocator(Record delegate) {
            super(delegate);
        }

        public UnsignedInteger relativeOffsetOfTheZip64EndOfCentralDirectoryRecord() {
            return this.delegate().uint32Value(ROZ64EOCDR);
        }
    }

    static final class EndOfCentralDirectory
    extends Record.Fowarding {
        public static final long SIGNATURE = 101010256L;
        public static final RecordDefinition.Field EOCDLS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "end of central dir signature");
        public static final RecordDefinition.Field NOTD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "number of this disk");
        public static final RecordDefinition.Field NOTDWTSITCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "number of the disk with the start of the central directory");
        public static final RecordDefinition.Field TNOEITCDOTD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "total number of entries in the central directory on this disk");
        public static final RecordDefinition.Field TNOEITCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "total number of entries in the central directory");
        public static final RecordDefinition.Field SOTCD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "size of the central directory");
        public static final RecordDefinition.Field OOSOCDWRTTSDN = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "offset of start of central directory with respect to the starting disk number");
        public static final RecordDefinition.Field ZFCL = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "ZIP file comment length");
        public static final RecordDefinition.Field ZFC = RecordDefinition.createLEField(RecordDefinition.Field.Type.VARIABLE, "ZIP file comment");
        public static final RecordDefinition DEFINITION = RecordDefinition.builder().name("End of Central Directory").fields((List<RecordDefinition.Field>)ImmutableList.of((Object)EOCDLS, (Object)NOTD, (Object)NOTDWTSITCD, (Object)TNOEITCDOTD, (Object)TNOEITCD, (Object)SOTCD, (Object)OOSOCDWRTTSDN, (Object)ZFCL, (Object)ZFC)).sizeDefinitionFields((Map<RecordDefinition.Field, RecordDefinition.Field>)ImmutableMap.of((Object)ZFC, (Object)ZFCL)).recordClass(EndOfCentralDirectory.class).signature(101010256L).signatureField((Optional<RecordDefinition.Field>)Optional.of((Object)EOCDLS)).build();
        public static final int MIN_SIZE = EndOfCentralDirectory.computeMinSize();
        public static final int MAX_SIZE = MIN_SIZE + 65535;

        private static int computeMinSize() {
            int minSize = 0;
            for (RecordDefinition.Field f : DEFINITION.fields()) {
                if (f.type() == RecordDefinition.Field.Type.VARIABLE) continue;
                minSize += f.type().size();
            }
            return minSize;
        }

        public EndOfCentralDirectory(Record delegate) {
            super(delegate);
        }

        public UnsignedInteger offsetOfStartOfCentralDirectoryWithRespectToTheStartDiskNumber() {
            return this.delegate().uint32Value(OOSOCDWRTTSDN);
        }
    }

    static final class CentralDirectoryHeader
    extends Record.Fowarding {
        private static final long SIGNATURE = 33639248L;
        public static final RecordDefinition.Field CFHS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "central file header signature");
        public static final RecordDefinition.Field VMB = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "version made by");
        public static final RecordDefinition.Field VNTE = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "version needed to extract");
        public static final RecordDefinition.Field GPBF = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "general purpose bit flag");
        public static final RecordDefinition.Field CM = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "compression method");
        public static final RecordDefinition.Field LMFT = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "last mod file time");
        public static final RecordDefinition.Field LMFD = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "last mod file date");
        public static final RecordDefinition.Field CRC32 = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "crc-32");
        public static final RecordDefinition.Field CS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "compressed size");
        public static final RecordDefinition.Field UCS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "uncompressed size");
        public static final RecordDefinition.Field FNL = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "file name length");
        public static final RecordDefinition.Field EFL = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "extra field length");
        public static final RecordDefinition.Field FCL = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "file comment length");
        public static final RecordDefinition.Field DNS = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "disk number start");
        public static final RecordDefinition.Field IFA = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_16, "internal file attributes");
        public static final RecordDefinition.Field EFA = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "external file attributes");
        public static final RecordDefinition.Field ROOLH = RecordDefinition.createLEField(RecordDefinition.Field.Type.UINT_32, "relative offset of local header");
        public static final RecordDefinition.Field FN = RecordDefinition.createLEField(RecordDefinition.Field.Type.VARIABLE, "file name");
        public static final RecordDefinition.Field EF = RecordDefinition.createLEField(RecordDefinition.Field.Type.VARIABLE, "extra field");
        public static final RecordDefinition.Field FC = RecordDefinition.createLEField(RecordDefinition.Field.Type.VARIABLE, "file comment");
        public static final RecordDefinition DEFINITION = RecordDefinition.builder().name("Central Directory Header").fields((List<RecordDefinition.Field>)ImmutableList.of((Object)CFHS, (Object)VMB, (Object)VNTE, (Object)GPBF, (Object)CM, (Object)LMFT, (Object)LMFD, (Object)CRC32, (Object)CS, (Object)UCS, (Object)FNL, (Object)EFL, (Object[])new RecordDefinition.Field[]{FCL, DNS, IFA, EFA, ROOLH, FN, EF, FC})).sizeDefinitionFields((Map<RecordDefinition.Field, RecordDefinition.Field>)ImmutableMap.of((Object)FN, (Object)FNL, (Object)EF, (Object)EFL, (Object)FC, (Object)FCL)).recordClass(CentralDirectoryHeader.class).signature(33639248L).signatureField((Optional<RecordDefinition.Field>)Optional.of((Object)CFHS)).build();

        public CentralDirectoryHeader(Record record) {
            super(record);
        }

        public int versionMadeBy() {
            return this.delegate().uint16Value(VMB);
        }

        public Platform platform() {
            return Platform.fromValue(this.versionMadeBy() >> 8);
        }

        public int majorVersion() {
            return (this.versionMadeBy() & 0xFF) / 10;
        }

        public int minorVersion() {
            return (this.versionMadeBy() & 0xFF) % 10;
        }

        public UnsignedInteger externalFileAttributes() {
            return this.delegate().uint32Value(EFA);
        }

        public Set<PosixFilePermission> posixPermissions() {
            if (this.platform() == Platform.UNIX) {
                return MorePosixFilePermissions.fromFileMode(this.externalFileAttributes().longValue() >> 16 & 0x1FFL);
            }
            return ImmutableSet.of();
        }

        public String filename() {
            return this.delegate().stringValue(FN, StandardCharsets.UTF_8);
        }

        static enum Platform {
            MSDOS_OS2(0),
            AMIGA(1),
            OPEN_VMS(2),
            UNIX(3),
            VM_CMS(4),
            ATARI_ST(5),
            OS2_HPFS(6),
            MACINTOSH(7),
            Z_SYSTEM(8),
            CP_M(9),
            WINDOWS_NTFS(10),
            MVS(11),
            VSE(12),
            ACORN_RISC(13),
            VFAT(14),
            ALTERNATE_MVS(15),
            BEOS(16),
            TANDEM(17),
            OS_400(18),
            OSX(19),
            UNKNOWN(-1);

            private final int value;

            private Platform(int value) {
                this.value = value;
            }

            public static Platform fromValue(int value) {
                for (Platform p : Platform.values()) {
                    if (p.value != value) continue;
                    return p;
                }
                return UNKNOWN;
            }
        }
    }

    static final class ZipReader {
        private final Map<Record, Long> recordPositions;
        private final SeekableByteChannelRecordReader reader;
        private final long zipSize;

        public ZipReader(SeekableByteChannelRecordReader reader, long zipSize) {
            this.reader = (SeekableByteChannelRecordReader)Preconditions.checkNotNull((Object)reader);
            this.recordPositions = Maps.newHashMap();
            this.zipSize = zipSize;
        }

        public long zipSize() {
            return this.zipSize;
        }

        public Optional<LocalFileHeader> readLocalFileHeader(long position) throws IOException {
            return this.readRecord(LocalFileHeader.DEFINITION, position);
        }

        public Optional<CentralDirectoryHeader> readCentralDirectoryHeader(long position) throws IOException {
            return this.readRecord(CentralDirectoryHeader.DEFINITION, position);
        }

        public Optional<EndOfCentralDirectory> readEndOfCentralDirectory(long position) throws IOException {
            return this.readRecord(EndOfCentralDirectory.DEFINITION, position);
        }

        public Optional<Zip64EndOfCentralDirectoryLocator> readZip64EndOfCentralDirectoryLocator(long position) throws IOException {
            return this.readRecord(Zip64EndOfCentralDirectoryLocator.DEFINITION, position);
        }

        public Optional<Zip64EndOfCentralDirectory> readZip64EndOfCentralDirectory(long position) throws IOException {
            return this.readRecord(Zip64EndOfCentralDirectory.DEFINITION, position);
        }

        private Optional<? extends Record> readRecord(RecordDefinition rd, long position) throws IOException {
            Optional<Record> ret = rd.signatureField().isPresent() ? this.readRecordWithSignature(rd, position) : this.doReadRecord(rd.recordClass(), rd, position);
            return ret;
        }

        private Optional<Record> readRecordWithSignature(RecordDefinition rd, long position) throws IOException {
            long signature = this.reader.uint32((RecordDefinition.Field)rd.signatureField().get(), rd, position).longValue();
            Optional<Record> ret = signature == rd.signature() ? this.doReadRecord(rd.recordClass(), rd, position) : Optional.absent();
            return ret;
        }

        private Optional<Record> doReadRecord(Class<? extends Record> recordClass, RecordDefinition rd, long position) throws IOException {
            Record record = this.createRecord(recordClass, this.readBasicRecord(rd, position));
            this.recordPositions.put(record, position);
            return Optional.of((Object)record);
        }

        private Record createRecord(Class<? extends Record> recordClass, Record delegate) {
            if (recordClass == CentralDirectoryHeader.class) {
                return new CentralDirectoryHeader(delegate);
            }
            if (recordClass == EndOfCentralDirectory.class) {
                return new EndOfCentralDirectory(delegate);
            }
            if (recordClass == Zip64EndOfCentralDirectoryLocator.class) {
                return new Zip64EndOfCentralDirectoryLocator(delegate);
            }
            if (recordClass == Zip64EndOfCentralDirectory.class) {
                return new Zip64EndOfCentralDirectory(delegate);
            }
            if (recordClass == LocalFileHeader.class) {
                return new LocalFileHeader(delegate);
            }
            throw new IllegalArgumentException("Unknow record type");
        }

        private Record readBasicRecord(RecordDefinition definition, long position) throws IOException {
            return new ByteBufferRecord(definition, this.reader.read(definition, position));
        }

        public long position(Record record) {
            return this.recordPositions.get(record);
        }
    }
}

