/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.mojo;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.cbi.mojo.AbstractPluginScannerMojo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.osgi.framework.BundleException;

public class TestPropertiesMojo
extends AbstractPluginScannerMojo {
    private static XMLParser parser = new XMLParser();
    protected File destination;

    @Override
    protected File getDestination() {
        return this.destination;
    }

    @Override
    protected void processPlugins(Properties properties, Map<File, OsgiManifest> plugins) throws Exception {
        HashMap<String, Plugin> model = new HashMap<String, Plugin>();
        for (Map.Entry<File, OsgiManifest> entry : plugins.entrySet()) {
            TestType type = this.getTestType(entry.getKey());
            OsgiManifest manifest = entry.getValue();
            model.put(manifest.getBundleSymbolicName(), new Plugin(manifest, type));
        }
        for (Plugin plugin : model.values()) {
            if (TestType.NONE == plugin.getTestType()) continue;
            OsgiManifest manifest = plugin.getManifest();
            properties.put(manifest.getBundleSymbolicName(), manifest.getBundleSymbolicName() + "_" + manifest.getBundleVersion());
            if (TestType.PERFTEST == plugin.getTestType()) {
                properties.put(manifest.getBundleSymbolicName() + ".has.performance.target", "true");
            }
            ArrayList<Plugin> dependencies = new ArrayList<Plugin>();
            this.collectRequiredBundles(plugin, model, dependencies, new HashSet<ArtifactKey>());
            StringBuilder sb = new StringBuilder();
            for (Plugin dependency : dependencies) {
                if (plugin == dependency || TestType.NONE == dependency.getTestType()) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("**/${").append(dependency.getManifest().getBundleSymbolicName()).append("}**");
            }
            properties.put(manifest.getBundleSymbolicName() + ".prerequisite.testplugins", sb.toString());
        }
    }

    private void collectRequiredBundles(Plugin plugin, Map<String, Plugin> model, Collection<Plugin> required, Set<ArtifactKey> visited) throws BundleException {
        ArtifactKey key = this.newArtifactKey(plugin);
        if (visited.add(key)) {
            required.add(plugin);
            OsgiManifest manifest = plugin.getManifest();
            String value = manifest.getValue("Require-Bundle");
            if (value == null) {
                return;
            }
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)value);
            if (elements == null) {
                return;
            }
            for (ManifestElement element : elements) {
                Plugin other = model.get(element.getValue());
                if (other == null) continue;
                this.collectRequiredBundles(other, model, required, visited);
            }
        }
    }

    private ArtifactKey newArtifactKey(Plugin plugin) {
        OsgiManifest m = plugin.getManifest();
        return new DefaultArtifactKey("eclipse-plugin", m.getBundleSymbolicName(), m.getBundleVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestType getTestType(File plugin) throws IOException {
        JarFile jar = new JarFile(plugin);
        try {
            Document document;
            ZipEntry entry = jar.getEntry("test.xml");
            if (entry == null) {
                TestType testType = TestType.NONE;
                return testType;
            }
            InputStream is = jar.getInputStream(entry);
            try {
                document = parser.parse((XMLSource)new XMLIOSource(is));
            }
            finally {
                IOUtil.close((InputStream)is);
            }
            for (Element element : document.getRootElement().getChildren("target")) {
                if (!"performance".equals(element.getAttributeValue("name"))) continue;
                TestType testType = TestType.PERFTEST;
                return testType;
            }
            TestType testType = TestType.TEST;
            return testType;
        }
        finally {
            jar.close();
        }
    }

    private static class Plugin {
        private final OsgiManifest manifest;
        private final TestType testType;

        public Plugin(OsgiManifest manifest, TestType testType) {
            this.manifest = manifest;
            this.testType = testType;
        }

        public OsgiManifest getManifest() {
            return this.manifest;
        }

        public TestType getTestType() {
            return this.testType;
        }
    }

    private static enum TestType {
        NONE,
        TEST,
        PERFTEST;

    }
}

