/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.mojo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="generate-api-build-xml", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateAPIBuildXMLMojo
extends AbstractMojo {
    private static final String API_BUILD_XML_FILE = ".apibuild.xml";
    private static final String API_NATURE = "org.eclipse.pde.api.tools.apiAnalysisNature";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public void execute() throws MojoExecutionException {
        File dotProject = new File(this.project.getBasedir(), ".project");
        if (!GenerateAPIBuildXMLMojo.isRelevantPackaging(this.project.getPackaging()) || !dotProject.exists()) {
            this.project.getProperties().setProperty("eclipserun.skip", "true");
            return;
        }
        if (GenerateAPIBuildXMLMojo.dotProjectContainsApiNature(dotProject)) {
            this.generateBuildXML();
        } else {
            this.project.getProperties().setProperty("eclipserun.skip", "true");
        }
    }

    private static boolean isRelevantPackaging(String packaging) {
        return "eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging);
    }

    private static boolean dotProjectContainsApiNature(File f) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(f);
            doc.getDocumentElement().normalize();
            NodeList natures = doc.getElementsByTagName("nature");
            for (int i = 0; i < natures.getLength(); ++i) {
                Node nature = natures.item(i);
                String sNature = nature.getTextContent();
                if (sNature == null || !API_NATURE.equals(sNature.trim())) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private void generateBuildXML() throws MojoExecutionException {
        System.out.println("Generating target/.apibuild.xml");
        File targetDir = new File(this.project.getBuild().getDirectory());
        if (!targetDir.isDirectory()) {
            targetDir.mkdirs();
        }
        File dotApiBuildXML = new File(targetDir, API_BUILD_XML_FILE);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(dotApiBuildXML));){
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bw.write("<project name=\"apigen\" default=\"apigen\">\n");
            bw.write("  <target name=\"apigen\">\n");
            bw.write("  \t<apitooling.apigeneration    \n");
            bw.write("      \tprojectname=\"" + this.calculateName() + "\"\n");
            bw.write("      \tproject=\"" + this.project.getBasedir() + "\"\n");
            bw.write("      \tbinary=\"" + this.getOutputFoldersAsPath() + "\"\n");
            bw.write("      \ttarget=\"" + targetDir + "\"\n");
            bw.write("      \tdebug=\"true\"\n");
            bw.write("      \n");
            bw.write("      />\n");
            bw.write("  </target>\n");
            bw.write("</project>\n");
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getOutputFoldersAsPath() throws MojoExecutionException {
        StringBuilder path = new StringBuilder();
        List outputJars = this.getEclipsePluginProject().getOutputJars();
        for (int i = 0; i < outputJars.size(); ++i) {
            if (i > 0) {
                path.append(File.pathSeparator);
            }
            path.append(((BuildOutputJar)outputJars.get(i)).getOutputDirectory().getAbsolutePath());
        }
        return path.toString();
    }

    private EclipsePluginProject getEclipsePluginProject() throws MojoExecutionException {
        return ((OsgiBundleProject)this.getBundleProject()).getEclipsePluginProject(DefaultReactorProject.adapt((MavenProject)this.project));
    }

    private BundleProject getBundleProject() throws MojoExecutionException {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (!(projectType instanceof BundleProject)) {
            throw new MojoExecutionException("Not a bundle project " + this.project.toString());
        }
        return (BundleProject)projectType;
    }

    private String calculateName() {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        ArtifactKey artifactKey = projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)this.project));
        String symbolicName = artifactKey.getId();
        String version = this.project.getProperties().getProperty("qualifiedVersion");
        return symbolicName + "_" + version;
    }
}

