/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.cbi.common.util.Paths;
import org.eclipse.cbi.common.util.Zips;
import org.eclipse.cbi.maven.plugins.jarsigner.AutoValue_RecursiveJarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.FilteredJarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.JarSigner;

public abstract class RecursiveJarSigner
extends FilteredJarSigner {
    abstract JarSigner delegate();

    abstract int maxDepth();

    abstract Log log();

    @Override
    int doSignJar(Path jar, JarSigner.Options options) throws IOException {
        return this.doSignJarRecursively(jar, options, 0);
    }

    private int doSignJarRecursively(Path file, JarSigner.Options options, int currentDepth) throws IOException {
        int nestedJarsSigned = 0;
        if (currentDepth >= this.maxDepth()) {
            this.log().info((CharSequence)("Signing of nested jars of '" + file + "' is disabled."));
        } else {
            nestedJarsSigned = this.signNestedJars(file, options, currentDepth);
        }
        return nestedJarsSigned + this.delegate().sign(file, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int signNestedJars(Path file, JarSigner.Options options, int currentDepth) throws IOException {
        Path tmpSignedJar;
        int numberOfSignedNestedJar;
        block5: {
            numberOfSignedNestedJar = 0;
            Path jarUnpackFolder = null;
            tmpSignedJar = null;
            try {
                jarUnpackFolder = Files.createTempDirectory(Paths.getParent((Path)file), file.getFileName().toString() + "_unpacked_", new FileAttribute[0]);
                Zips.unpackJar((Path)file, (Path)jarUnpackFolder);
                NestedJarSigner nestedJarSigner = new NestedJarSigner(currentDepth, options);
                Files.walkFileTree(jarUnpackFolder, nestedJarSigner);
                Zips.packJar((Path)jarUnpackFolder, (Path)file, (boolean)false);
                numberOfSignedNestedJar = nestedJarSigner.getNumberOfSignedNestedJar();
                if (jarUnpackFolder == null) break block5;
            }
            catch (Throwable throwable) {
                if (jarUnpackFolder != null) {
                    Paths.deleteQuietly(jarUnpackFolder);
                }
                if (tmpSignedJar != null) {
                    Paths.deleteQuietly(tmpSignedJar);
                }
                throw throwable;
            }
            Paths.deleteQuietly((Path)jarUnpackFolder);
        }
        if (tmpSignedJar != null) {
            Paths.deleteQuietly(tmpSignedJar);
        }
        return numberOfSignedNestedJar;
    }

    public static Builder builder() {
        return new AutoValue_RecursiveJarSigner.Builder().filter(FilteredJarSigner.Filters.ALWAYS_SIGN);
    }

    public static abstract class Builder {
        public abstract Builder maxDepth(int var1);

        public abstract Builder filter(FilteredJarSigner.Filter var1);

        public abstract Builder delegate(JarSigner var1);

        public abstract Builder log(Log var1);

        public abstract RecursiveJarSigner build();
    }

    private final class NestedJarSigner
    extends SimpleFileVisitor<Path> {
        private final int currentDepth;
        private final JarSigner.Options options;
        private int numberOfSignedNestedJar;

        NestedJarSigner(int currentDepth, JarSigner.Options options) {
            this.currentDepth = currentDepth;
            this.options = options;
            this.numberOfSignedNestedJar = 0;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileSystem().getPathMatcher("glob:**.jar").matches(file) && RecursiveJarSigner.this.filter().shouldBeSigned(file)) {
                this.numberOfSignedNestedJar += RecursiveJarSigner.this.doSignJarRecursively(file, this.options, this.currentDepth + 1);
            }
            return FileVisitResult.CONTINUE;
        }

        public int getNumberOfSignedNestedJar() {
            return this.numberOfSignedNestedJar;
        }
    }
}

