/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.cbi.maven.plugins.jarsigner.JarSigner;

public abstract class FilteredJarSigner
implements JarSigner {
    abstract Filter filter();

    @Override
    public final int sign(Path jar, JarSigner.Options options) throws IOException {
        if (this.filter().shouldBeSigned(jar)) {
            return this.doSignJar(jar, options);
        }
        return 0;
    }

    abstract int doSignJar(Path var1, JarSigner.Options var2) throws IOException;

    public static enum Filters implements Filter
    {
        ALWAYS_SIGN{

            @Override
            public boolean shouldBeSigned(Path jar) throws IOException {
                return true;
            }
        }
        ,
        NEVER_SIGN{

            @Override
            public boolean shouldBeSigned(Path jar) throws IOException {
                return false;
            }
        };

    }

    public static interface Filter {
        public boolean shouldBeSigned(Path var1) throws IOException;
    }
}

