/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.cbi.common.security.MessageDigestAlgorithm;
import org.eclipse.cbi.common.security.SignatureAlgorithm;
import org.eclipse.cbi.maven.plugins.jarsigner.AutoValue_JarSigner_Options;

public interface JarSigner {
    public int sign(Path var1, Options var2) throws IOException;

    public static abstract class Options {
        private static final int CONNECT_TIMEOUT_MS__DEFAULT = 20000;

        public abstract MessageDigestAlgorithm digestAlgorithm();

        public abstract SignatureAlgorithm signatureAlgorithm();

        public abstract int connectTimeoutMillis();

        public static Builder builder() {
            return new AutoValue_JarSigner_Options.Builder().signatureAlgorithm(SignatureAlgorithm.DEFAULT).digestAlgorithm(MessageDigestAlgorithm.DEFAULT).connectTimeoutMillis(20000);
        }

        public static Builder copy(Options option) {
            return Options.builder().digestAlgorithm(option.digestAlgorithm()).signatureAlgorithm(option.signatureAlgorithm()).connectTimeoutMillis(option.connectTimeoutMillis());
        }

        public static abstract class Builder {
            public abstract Builder digestAlgorithm(MessageDigestAlgorithm var1);

            public abstract Builder signatureAlgorithm(SignatureAlgorithm var1);

            public abstract Builder connectTimeoutMillis(int var1);

            public abstract Options build();
        }
    }
}

