/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.cbi.maven.Logger;
import org.eclipse.cbi.maven.MavenLogger;
import org.eclipse.cbi.maven.http.AbstractCompletionListener;
import org.eclipse.cbi.maven.http.CompletionListener;
import org.eclipse.cbi.maven.http.HttpClient;
import org.eclipse.cbi.maven.http.HttpRequest;
import org.eclipse.cbi.maven.http.HttpResult;
import org.eclipse.cbi.maven.plugins.jarsigner.AutoValue_RemoteJarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.FilteredJarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.JarSigner;

public abstract class RemoteJarSigner
extends FilteredJarSigner {
    private static final String PART_NAME = "file";

    abstract URI serverUri();

    abstract HttpClient httpClient();

    abstract Log log();

    @Override
    public int doSignJar(Path jar, JarSigner.Options options) throws IOException {
        this.log().info((CharSequence)("Signing jar: " + jar.toString()));
        this.log().debug((CharSequence)("Jar signing options: " + options.toString()));
        HttpRequest request = HttpRequest.on((URI)this.serverUri()).withParam(PART_NAME, jar).withParam("digestalg", options.digestAlgorithm().standardName()).withParam("sigalg", options.signatureAlgorithm().standardName()).build();
        this.log().debug((CharSequence)("Jar signing request: " + request.toString()));
        OverwriteJarOnSuccess completionListener = new OverwriteJarOnSuccess(jar.getParent(), jar.getFileName().toString(), RemoteJarSigner.class.getSimpleName(), (Logger)new MavenLogger(this.log()), jar);
        if (this.httpClient().send(request, (CompletionListener)completionListener)) {
            return 1;
        }
        return 0;
    }

    public static Builder builder() {
        return new AutoValue_RemoteJarSigner.Builder().filter(FilteredJarSigner.Filters.ALWAYS_SIGN);
    }

    public static abstract class Builder {
        public abstract Builder filter(FilteredJarSigner.Filter var1);

        public abstract Builder serverUri(URI var1);

        public abstract Builder httpClient(HttpClient var1);

        public abstract Builder log(Log var1);

        public abstract RemoteJarSigner build();
    }

    private static final class OverwriteJarOnSuccess
    extends AbstractCompletionListener {
        private final Path jar;

        private OverwriteJarOnSuccess(Path errorLogFolder, String errologPrefix, String errorLogSuffix, Logger log, Path jar) {
            super(errorLogFolder, errologPrefix, errorLogSuffix, log);
            this.jar = jar;
        }

        public void onSuccess(HttpResult result) throws IOException {
            if (result.contentLength() == 0L) {
                throw new IOException("Length of the returned content is 0");
            }
            result.copyContent(this.jar, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            if (Files.size(this.jar) == 0L) {
                throw new IOException("Size of the returned signed Jar is 0");
            }
        }
    }
}

