/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner.mojo;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.eclipse.cbi.common.security.MessageDigestAlgorithm;
import org.eclipse.cbi.common.security.SignatureAlgorithm;
import org.eclipse.cbi.maven.ExceptionHandler;
import org.eclipse.cbi.maven.Logger;
import org.eclipse.cbi.maven.MavenLogger;
import org.eclipse.cbi.maven.http.HttpClient;
import org.eclipse.cbi.maven.http.RetryHttpClient;
import org.eclipse.cbi.maven.http.apache.ApacheHttpClient;
import org.eclipse.cbi.maven.plugins.jarsigner.EclipseJarSignerFilter;
import org.eclipse.cbi.maven.plugins.jarsigner.JarResigner;
import org.eclipse.cbi.maven.plugins.jarsigner.JarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.RecursiveJarSigner;
import org.eclipse.cbi.maven.plugins.jarsigner.RemoteJarSigner;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE)
public class SignMojo
extends AbstractMojo {
    private static final String DEFAULT_RETRY_TIMER_STRING = "10";
    private static final int DEFAULT_RETRY_TIMER = Integer.parseInt("10");
    private static final String DEFAULT_RETRY_LIMIT_STRING = "3";
    private static final int DEFAULT_RETRY_LIMIT = Integer.parseInt("3");
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(required=true, property="cbi.jarsigner.signerUrl", defaultValue="https://cbi.eclipse.org/jarsigner/sign")
    private String signerUrl;
    @Parameter(property="cbi.jarsigner.skip", defaultValue="false")
    private boolean skip;
    @Deprecated
    @Parameter(property="continueOnFail", defaultValue="false")
    private boolean deprecatedContinueOnFail;
    @Parameter(property="cbi.jarsigner.continueOnFail", defaultValue="false")
    private boolean continueOnFail;
    @Deprecated
    @Parameter(property="retryLimit", defaultValue="3")
    private int deprecatedRetryLimit;
    @Parameter(property="cbi.jarsigner.retryLimit", defaultValue="3")
    private int retryLimit;
    @Deprecated
    @Parameter(property="retryTimer", defaultValue="10")
    private int deprecatedRetryTimer;
    @Parameter(property="cbi.jarsigner.retryTimer", defaultValue="10")
    private int retryTimer;
    @Parameter(defaultValue="false")
    private boolean excludeInnerJars;
    @Deprecated
    @Parameter
    private List<String> supportedProjectTypes = Arrays.asList("jar", "war", "bundle", "maven-plugin", "eclipse-plugin", "eclipse-test-plugin", "eclipse-feature");
    @Parameter(property="cbi.jarsigner.resigningStrategy", defaultValue="RESIGN")
    private JarResigner.Strategy resigningStrategy;
    @Parameter(property="cbi.jarsigner.digestAlgorithm", defaultValue="DEFAULT")
    private MessageDigestAlgorithm digestAlgorithm;
    @Parameter(property="cbi.jarsigner.signatureAlgorithm", defaultValue="DEFAULT")
    private SignatureAlgorithm signatureAlgorithm;
    @Deprecated
    @Parameter(property="cbi.jarsigner.connectTimeoutMillis", defaultValue="5000")
    private int connectTimeoutMillis;
    @Parameter(property="cbi.jarsigner.timeoutMillis", defaultValue="0")
    private int timeoutMillis;
    @Parameter(property="cbi.jarsigner.sigFile", defaultValue="")
    private String sigFile;
    @Parameter(property="cbi.jarsigner.archiveDirectory")
    private File archiveDirectory;
    @Parameter
    private String[] includes = new String[]{"**/*.?ar"};
    @Parameter(property="cbi.jarsigner.processMainArtifact", defaultValue="true")
    private boolean processMainArtifact;
    @Parameter(property="cbi.jarsigner.processAttachedArtifacts", defaultValue="true")
    private boolean processAttachedArtifacts;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip jar signing");
            return;
        }
        if (this.project.getArtifact() == null && this.project.getAttachedArtifacts().isEmpty()) {
            this.getLog().info((CharSequence)"No jars to sign");
        } else {
            Object mainArtifact;
            JarSigner jarSigner = this.createJarSigner();
            if (this.processMainArtifact && (mainArtifact = this.project.getArtifact()) != null) {
                this.signArtifact(jarSigner, (Artifact)mainArtifact);
            }
            if (this.processAttachedArtifacts) {
                for (Artifact artifact : this.project.getAttachedArtifacts()) {
                    this.signArtifact(jarSigner, artifact);
                }
            }
            if (this.archiveDirectory != null && this.includes != null && this.includes.length > 0) {
                try {
                    List jarFiles = FileUtils.getFiles((File)this.archiveDirectory, (String)String.join((CharSequence)",", this.includes), (String)"");
                    for (File jarFile : jarFiles) {
                        this.signArtifact(jarSigner, jarFile);
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to scan archive directory for JARs: " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void signArtifact(JarSigner jarSigner, Artifact artifact) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (artifactFile != null) {
            this.signArtifact(jarSigner, artifactFile);
        } else {
            this.getLog().debug((CharSequence)("No file is associated with artifact '" + artifact.toString() + "'"));
        }
    }

    private void signArtifact(JarSigner jarSigner, File jarFile) throws MojoExecutionException {
        try {
            if (new EclipseJarSignerFilter(this.getLog()).shouldBeSigned(jarFile.toPath())) {
                JarSigner.Options options = JarSigner.Options.builder().signatureAlgorithm(this.signatureAlgorithm).digestAlgorithm(this.digestAlgorithm).connectTimeout(Duration.ofMillis(this.connectTimeoutMillis)).timeout(Duration.ofMillis(this.timeoutMillis)).sigFile(Strings.nullToEmpty((String)this.sigFile)).build();
                jarSigner.sign(jarFile.toPath(), options);
            }
        }
        catch (IOException e) {
            new ExceptionHandler(this.getLog(), this.continueOnFail()).handleError("Unable to sign jar '" + jarFile.toString() + "'", (Exception)e);
        }
    }

    private boolean continueOnFail() {
        return this.deprecatedContinueOnFail || this.continueOnFail;
    }

    private int retryLimit() {
        if (this.deprecatedRetryLimit != DEFAULT_RETRY_LIMIT && this.retryLimit == DEFAULT_RETRY_LIMIT) {
            return this.deprecatedRetryLimit;
        }
        return this.retryLimit;
    }

    private int retryTimer() {
        if (this.deprecatedRetryTimer != DEFAULT_RETRY_TIMER && this.retryTimer == DEFAULT_RETRY_TIMER) {
            return this.deprecatedRetryTimer;
        }
        return this.retryTimer;
    }

    private JarSigner createJarSigner() {
        HttpClient httpClient = RetryHttpClient.retryRequestOn((HttpClient)ApacheHttpClient.create((Logger)new MavenLogger(this.getLog()))).log((Logger)new MavenLogger(this.getLog())).maxRetries(this.retryLimit()).waitBeforeRetry((long)this.retryTimer(), TimeUnit.SECONDS).build();
        return RecursiveJarSigner.builder().filter(new EclipseJarSignerFilter(this.getLog())).log(this.getLog()).maxDepth(this.excludeInnerJars ? 0 : 1).delegate(JarResigner.create(this.resigningStrategy, RemoteJarSigner.builder().httpClient(httpClient).serverUri(URI.create(this.signerUrl)).log(this.getLog()).build(), this.getLog())).build();
    }
}

